/*
 * $Id: Matrix.java,v 1.2 2005/04/14 14:44:42 ahmed Exp $
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jaligner.matrix;

import java.io.Serializable;
import java.util.HashMap;

/**
 * Scoring matrix.
 * 
 * @author Ahmed Moustafa (ahmed@users.sf.net)
 */

public class Matrix implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 3833742170619524400L;

    /**
     * Matrix id (or name)
     */
    private String id = null;
    
    /**
     * Scores
     */
    private float[][] scores = null;
    
    /**
     * String to Index Map
     */
    private HashMap<String, Integer> StringPosMap = new HashMap<String, Integer>();
    
    public Matrix(String id, float[][] scores, HashMap<String, Integer> StringPosMap) {
        this.id = id;
        this.scores = scores;
        this.StringPosMap = StringPosMap;
    }
    
    /**
     * @return Returns the id.
     */
    public String getId() {
        return this.id;
    }
    
    /**
     * @return Returns the scores.
     */
//    public float[][] getScores() {
//        return this.scores;
//    }
    
    /**
     * 
     * @param a
     * @param b
     * @return score
     */
    public float getScore(String a, String b) {
    	int i1 = getPosition(a);
    	int i2 = getPosition(b);
    	try {
    		return this.scores[getPosition(a)][getPosition(b)];
    	} catch (Exception e) {
    		System.out.println("Tried to access (" + i1 + ", " + i2 + ") from (" + a + ", " + b + ")");
    		return 0f;
    	}
    }
    
    private int getPosition(String a) {
    	return StringPosMap.get(a);
    }
    
    public String toString() {
		StringBuffer buffer = new StringBuffer();
		for (int i=0; i<this.scores.length; i++) {
			for(int j=0; j<this.scores[i].length; j++) {
				buffer.append(this.scores[i][j]); buffer.append(" ");
			}
			buffer.append("\n");
		}
		return buffer.toString();
    }
}