package swgTest;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;

public class EventLog {
	private HashMap<String, TreeMap<Date, String>> traces;
	private HashMap<TreeMap<Date, String>, Vector<String>> uniqueTraces;
	private HashSet<String> activities;
	private HashSet<String> cases;
	
	public EventLog() {
		traces = new HashMap<String, TreeMap<Date, String>>();
		uniqueTraces = new HashMap<TreeMap<Date, String>, Vector<String>>();
		activities = new HashSet<String>();
		cases = new HashSet<String>();
	}
	
	public TreeMap<Date, String> getTraceByID(String caseID) {
		return traces.get(caseID);
	}
	
	public Integer getNumCases() {
		return cases.size();
	}
	
	public Integer getNumActivities() {
		return activities.size();
	}
	
	public String[] getActivities() {
		return activities.toArray(new String[0]);
	}
	
	public String[] getCases() {
		return cases.toArray(new String[0]);
	}
	
	public String[] getTraceIDs() {
		return (String[])traces.keySet().toArray();
	}

	public ArrayList<TreeMap<Date, String>> getSequences() {
		// TODO Auto-generated method stub
		ArrayList<TreeMap<Date, String>> t = new ArrayList<TreeMap<Date, String>>();
		t.addAll(uniqueTraces.keySet());
		return t;
	}
	
	public Vector<String> getCaseIDsForSequence(TreeMap<Date, String> key) {
		return uniqueTraces.get(key);
	}
	
	public Integer getNumUniqueTraces() {
		return uniqueTraces.size();
	}
	
	public void readCSV(String fname, String separator, boolean skipFirstLine, String dateFormat) {
		BufferedReader br;
    	Date date;

    	SimpleDateFormat simpleFormat = (SimpleDateFormat) DateFormat.getDateInstance();
        if (dateFormat != null)
        	simpleFormat.applyPattern(dateFormat);

		try {
			br = new BufferedReader(new FileReader(fname));

	        String line = br.readLine();
	        if (skipFirstLine) {
	        	line=br.readLine();
	        }
	        while (line != null) {
	        	String[] parts = line.split(separator);
	        	String caseID = parts[0];
	        	String activityID = parts[1];
	        	String timeStamp = parts[2];
//				String originator = parts[3];
	        	TreeMap<Date, String> v = traces.get(caseID);
	        	if (v == null) {
	        		v = new TreeMap<Date, String>();
	        		traces.put(caseID, v);
	        	}
	        	if (dateFormat != null)
	        		date = simpleFormat.parse(timeStamp);
	        	else
	        		date = new Date(v.size()+1);
	        	v.put(date, activityID);
	        	activities.add(activityID);
	        	cases.add(caseID);
	            line = br.readLine();
	        }
	    } catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
	    } catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		for (String CaseID : traces.keySet() ) {
			TreeMap<Date, String> sequence = traces.get(CaseID);
        	Vector<String> cases = uniqueTraces.get(sequence);
        	if (cases == null) {
        		cases = new Vector<String>();
        		uniqueTraces.put(sequence, cases);
        	}
        	cases.add(CaseID);
		}
	}

}
