package swgTest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;

// import org.processmining.framework.util.CommandLineArgumentList;
import jaligner.Alignment;
import jaligner.Sequence;
import jaligner.SmithWatermanGotoh;
import jaligner.matrix.Matrix;

public class SWGTest {

	private static boolean automated = true;
	private static boolean skipFirstLine = true;
	private static boolean useTS = false;

	private static float costGapOpen = 0f;
	private static float costGapExtend = 0f;
	private static float matchScore = 2f;
	private static float mismatchPenalty = -1f;
	
	private static boolean useSim = true;
	private static boolean forceSymmetry = true;	
	private static boolean penalizeImproperCompletion = false;
	private static String miner = "FHM";

	private static float mismatchPenaltyRelative = -0.5f;
	private static float costGapExtendRelative = 0.5f;
	private static float costGapOpenRelative = 1f;
	private static int numDimensions = -1;
	private static int numClusters = 2;
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {

		if (args.length != 3) {
			System.out.println("Usage: SWGTest filename skipFirstLine useTimeStamp");
			System.exit(-1);
		}

		String fname = args[0];
		if (args.length >= 1) 
			skipFirstLine = Boolean.parseBoolean(args[1]);
		if (args.length >= 2)
			useTS = Boolean.parseBoolean(args[2]);

		EventLog log = new EventLog();
		if (useTS)
			log.readCSV(fname, ";", skipFirstLine, "dd.MM.yyyy HH:mm:ss");
		else
			log.readCSV(fname, ";", skipFirstLine, null);

		getAck("Read log file " + fname);

		String[] activities = log.getActivities();
		ArrayList<TreeMap<Date, String>> sequences = log.getSequences();
		
		for (float mismatchPenaltyRelative : new float[]{ 0.0f, -0.5f, -1.0f, -2.0f }) {
//		for (float mismatchPenaltyRelative : new float[]{ 0.0f, -0.5f }) { // first part
//		for (float mismatchPenaltyRelative : new float[]{ -1.0f, -2.0f }) { // second part
			SWGTest.mismatchPenaltyRelative = mismatchPenaltyRelative;
			for (float costGapOpenRelative : new float[] { 0.0f }) { // The case for 0.0f is handled by setting useSim to true
//			for (float costGapOpenRelative : new float[] { 1.0f, 0.5f }) { // The case for 0.0f is handled by setting useSim to true
				SWGTest.costGapOpenRelative = costGapOpenRelative;
				for (float costGapExtendRelative : new float[] { 0.0f }) { // The case for 0.0f is handled by setting useSim to true
//				for (float costGapExtendRelative : new float[] { 1.0f, 0.5f }) { // The case for 0.0f is handled by setting useSim to true
					SWGTest.costGapExtendRelative = costGapExtendRelative;
					for (int numDimensions : new int[] { -1, -3 }) {
						SWGTest.numDimensions = numDimensions;
						for (int numClusters : new int[] { 9, 6, 3 }) {
							SWGTest.numClusters = numClusters;

							matchScore = 1f;
							mismatchPenalty = matchScore * mismatchPenaltyRelative;
							costGapOpen = matchScore * costGapOpenRelative;
							costGapExtend = costGapOpen * costGapExtendRelative;
							
							System.out.println("skipFirstLine:              " + skipFirstLine);
							System.out.println("mismatchPenaltyRelative:    " + mismatchPenaltyRelative);
							System.out.println("costGapOpenRelative:        " + costGapOpenRelative);
							System.out.println("costGapExtendRelative:      " + costGapExtendRelative);
							System.out.println("numDimensions:              " + numDimensions);
							System.out.println("penalizeImproperCompletion: " + penalizeImproperCompletion);
							System.out.println("miner:                      " + miner);
							System.out.println("useTimeStamps:   " + useTS);
							System.out.println("useSim:          " + useSim);
							System.out.println("forceSymmetry:   " + forceSymmetry);
							System.out.println("costGapOpen:     " + costGapOpen);
							System.out.println("costGapExtend:   " + costGapExtend);
							System.out.println("matchScore:      " + matchScore);
							System.out.println("mismatchPenalty: " + mismatchPenalty);

							getAck("Read parameters");

							// m is a Map from Activity Strings to indexes in the activity similarity matrix m1 (and matrix)
							HashMap<String, Integer> m = new HashMap<String, Integer>();
							float[][] f = new float[log.getNumActivities()][log.getNumActivities()];
							for (int i = 0; i < log.getNumActivities(); i++) {
								m.put(activities[i], i);
								for (int j = 0; j < log.getNumActivities(); j++)
									// This is really really simple, and can possibly be improved upon with semantic knowledge of the individual activities				
									f[i][j] = (i==j) ? matchScore : mismatchPenalty;
							}
							Matrix matrix = new Matrix("m1", f, m);

							getAck("Created activity similarity matrix");

							// d is a Map from Sequence Vectors of Strings to indexes in the sequence dissimilarity matrix dd
							HashMap<TreeMap<Date, String>, Integer> d = new HashMap<TreeMap<Date, String>, Integer>();
							double[][] dd = new double[sequences.size()][sequences.size()];
							int i = 0;
							for (TreeMap<Date, String> sequenceA : sequences) {
								System.out.print("Aligning " + i + " ");
								d.put(sequenceA, i);
								if (forceSymmetry) {
									for (int j = i; j < sequences.size(); j++) {
										TreeMap<Date, String> sequenceB = sequences.get(j);
										Alignment a = SmithWatermanGotoh.align(new Sequence(sequenceA.values().toArray(new String[0])), new Sequence(sequenceB.values().toArray(new String[0])), matrix, costGapOpen, costGapExtend);
										float sim;
										if (useSim)
											// The similarity is the number of matches of the aligned sequences. Similarity is increased for an exact match and for a similar match.
											// Similar match means a similarity score of the aligned activities of 0 or greater. This does not take into account any gaps.
											sim = a.getSimilarity();
										// The alignment score is the sum of activity similarity score for aligned activities and is decreased by the cost of a gap opening or gap extension whenever
										// the alignment contains a gap on either or both sequences.
										else
											sim = a.calculateScore();				
										if (sim == 0)
											dd[i][j] = 1d;				
										else
											dd[i][j] = 1d / sim;
										// Forcing dd to be symmetrical
										dd[j][i] = dd[i][j];
										System.out.print(".");
									}
								} else {
									for (int j = 0; j < sequences.size(); j++) {
										TreeMap<Date, String> sequenceB = sequences.get(j);
										Alignment a = SmithWatermanGotoh.align(new Sequence(sequenceA.values().toArray(new String[0])), new Sequence(sequenceB.values().toArray(new String[0])), matrix, costGapOpen, costGapExtend);
										float sim;
										if (useSim)
											// The similarity is the number of matches of the aligned sequences. Similarity is increased for an exact match and for a similar match.
											// Similar match means a similarity score of the aligned activities of 0 or greater. This does not take into account any gaps.
											sim = a.getSimilarity();
										// The alignment score is the sum of activity similarity score for aligned activities and is decreased by the cost of a gap opening or gap extension whenever
										// the alignment contains a gap on either or both sequences.
										else
											sim = a.calculateScore();				
										if (sim == 0)
											dd[i][j] = 1d;				
										else
											dd[i][j] = 1d / sim;
										System.out.print(".");
									}
								}
								i++;
								System.out.println();
							}

							getAck("Created trace dissimilarity matrix");

							try {
								BufferedWriter bw = new BufferedWriter(new FileWriter(fname("simMatrix", "csv")));
								for (TreeMap<Date, String> sequence : sequences) {
									bw.write("\"X" + log.getCaseIDsForSequence(sequence).get(0) + "\", ");
								}
								bw.write("\b\b\n");
								for (int c=0;c<dd.length;c++) {
									for(int r=0;r<dd.length;r++) {
										bw.write(String.format("%.3f", dd[r][c]));
										if (r==dd.length-1) {
											bw.write("\n");
										} else
											bw.write(", ");
									}
								}
								bw.close();
							} catch (IOException e) {
								;
							}

							getAck("Written R matrix to " + fname("simMatrix", "csv"));

							try {
								BufferedWriter bw = new BufferedWriter(new FileWriter(fname("alignCluster", "R")));
								bw.write("set.seed(2) \n");
								bw.write("s <- read.csv(\"" + fname("simMatrix", "csv") + "\") \n");
								bw.write("s <- s[, 1:(ncol(s)-1)] \n");
								bw.write("sm <- as.matrix(s) \n");
								bw.write("colnames(sm) <- names(s) \n");
								bw.write("rownames(sm) <- names(s) \n");
								switch (numDimensions) {
								case -1 : { bw.write("mds <- cmdscale(sm, k=ceiling(sqrt(ncol(sm))) ) \n"); break; }
								case -2 : { bw.write("mds <- cmdscale(sm, k=ceiling(log10(ncol(sm))) ) \n"); break; }
								case -3 : { bw.write("mds <- cmdscale(sm, k=ceiling(log(ncol(sm))) ) \n"); break; }
								case -4 : { bw.write("mds <- cmdscale(sm, k=ceiling(log2(ncol(sm))) ) \n"); break; }
								default : { bw.write("mds <- cmdscale(sm, k=ceiling("+numDimensions+") ) \n"); break; }
								}
								bw.write("clusters <- kmeans(mds, " + numClusters + ", nstart=25, iter.max=25) \n");
								bw.write("for (c in 1:" + numClusters + ") { \n");
								bw.write("	write(names(clusters$cluster[clusters$cluster==c]), file=paste(\"C\", c, \"_" + fname("cluster", "txt") + "\", sep=\"\")) \n");
								bw.write("} \n");
								bw.close();
							} catch (IOException e) {
								;
							}

							getAck("Written R script to " + fname("alignCluster", "R"));

							try {
								Process p = new ProcessBuilder("R", "CMD", "BATCH", "--vanilla", fname("alignCluster", "R"), fname("alignCluster", "output.txt")).start();
								p.waitFor();
							} catch (Exception e) {
								e.printStackTrace();
								System.exit(-1);
							}

							getAck("Run R and written clusters to files " + fname("CX_", "txt") + " and output to " + fname("alignCluster", "output.txt"));

							// Cluster 0 is all traces in the log, as a reference for the subsequent mining algorithms
							// writeCluster0(log);

							for (int c=1; c<=numClusters; c++)
								writeXES(c, log);

							getAck("Written clusters to XES");

							for (int c=1; c<=numClusters; c++) {
								write_prom_script(c);
							}

							getAck("Written ProM scripts to file");

							for (int c=1; c<=numClusters; c++) {
								String[]	l = { "-f", "C" + c + fname("_ProMScript", "txt") };
								try {
									org.processmining.contexts.cli.CLI.main( l );
								} catch (Throwable e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
							}
							getAck("Finished running ProM scripts");

							System.out.println("Done."); System.out.flush();
						}
					}
				}
			}		
		}

		System.exit(0);
	}
/*
	private static void main(String[] args) {

		if (args.length != 13) {
			System.out.println("Usage: SWGTest filename skipFirstLine useTimeStamp mismatchPenaltyRelative costGapOpenRelative costGapExtendRelative useSim forceSymmetry numDimensions numClusters penalizeImproperCompletion Miner automated");
			System.exit(-1);
		}
		
		String fname = args[0];
	
		if (args.length >= 1) 
			skipFirstLine = Boolean.parseBoolean(args[1]);
		if (args.length >= 2)
			useTS = Boolean.parseBoolean(args[2]);
		if (args.length >= 3) 
			mismatchPenaltyRelative = Float.parseFloat(args[3]);
		if (args.length >= 4)
			costGapOpenRelative = Float.parseFloat(args[4]);
		if (args.length >= 5)
			costGapExtendRelative = Float.parseFloat(args[5]);
		if (args.length >= 6)
			useSim = Boolean.parseBoolean(args[6]);
		if (args.length >= 7)
			forceSymmetry = Boolean.parseBoolean(args[7]);
		if (args.length >= 8)
			try {
				numDimensions = Math.abs(Integer.parseInt(args[8]));
			} catch (NumberFormatException e) {
				if (args[8].equals("sqrt")) numDimensions = -1;
				if (args[8].equals("log10")) numDimensions = -2;
				if (args[8].equals("loge")) numDimensions = -3;
				if (args[8].equals("log2")) numDimensions = -4;
			}
		if (args.length >= 9)
			numClusters = Math.abs(Integer.parseInt(args[9]));
		if (args.length >= 11)
			penalizeImproperCompletion = Boolean.parseBoolean(args[10]);
		if (args.length >= 12)
			miner = args[11];
		if (args.length >= 13)
			automated = Boolean.parseBoolean(args[12]);
		
		matchScore = 1f;
		mismatchPenalty = matchScore * mismatchPenaltyRelative;
		costGapOpen = matchScore * costGapOpenRelative;
		costGapExtend = costGapOpen * costGapExtendRelative;
		
		System.out.println("skipFirstLine:              " + skipFirstLine);
		System.out.println("mismatchPenaltyRelative:    " + mismatchPenaltyRelative);
		System.out.println("costGapOpenRelative:        " + costGapOpenRelative);
		System.out.println("costGapExtendRelative:      " + costGapExtendRelative);
		System.out.println("numDimensions:              " + numDimensions);
		System.out.println("penalizeImproperCompletion: " + penalizeImproperCompletion);
		System.out.println("miner:                      " + miner);
		System.out.println("useTimeStamps:   " + useTS);
		System.out.println("useSim:          " + useSim);
		System.out.println("forceSymmetry:   " + forceSymmetry);
		System.out.println("costGapOpen:     " + costGapOpen);
		System.out.println("costGapExtend:   " + costGapExtend);
		System.out.println("matchScore:      " + matchScore);
		System.out.println("mismatchPenalty: " + mismatchPenalty);
		
		getAck("Read parameters");

		EventLog log = new EventLog();
		if (useTS)
			log.readCSV(fname, ";", skipFirstLine, "dd.MM.yyyy HH:mm:ss");
		else
			log.readCSV(fname, ";", skipFirstLine, null);

		getAck("Read log file " + fname);
		
		String[] activities = log.getActivities();
		ArrayList<TreeMap<Date, String>> sequences = log.getSequences();
		
		// m is a Map from Activity Strings to indexes in the activity similarity matrix m1 (and matrix)
		HashMap<String, Integer> m = new HashMap<String, Integer>();
		float[][] f = new float[log.getNumActivities()][log.getNumActivities()];
		for (int i = 0; i < log.getNumActivities(); i++) {
			m.put(activities[i], i);
			for (int j = 0; j < log.getNumActivities(); j++)
// This is really simple, and can possibly be improved upon with semantic knowledge of the individual activities				
				f[i][j] = (i==j) ? matchScore : mismatchPenalty;
		}
		Matrix matrix = new Matrix("m1", f, m);

		getAck("Created activity similarity matrix");
		
		// d is a Map from Sequence Vectors of Strings to indexes in the sequence dissimilarity matrix dd
		HashMap<TreeMap<Date, String>, Integer> d = new HashMap<TreeMap<Date, String>, Integer>();
		double[][] dd = new double[sequences.size()][sequences.size()];
		int i = 0;
		for (TreeMap<Date, String> sequenceA : sequences) {
			System.out.print("Aligning " + i + " ");
			d.put(sequenceA, i);
			if (forceSymmetry) {
				for (int j = i; j < sequences.size(); j++) {
					TreeMap<Date, String> sequenceB = sequences.get(j);
					Alignment a = SmithWatermanGotoh.align(new Sequence(sequenceA.values().toArray(new String[0])), new Sequence(sequenceB.values().toArray(new String[0])), matrix, costGapOpen, costGapExtend);
					float sim;
					if (useSim)
	// The similarity is the number of matches of the aligned sequences. Similarity is increased for an exact match and for a similar match.
	// Similar match means a similarity score of the aligned activities of 0 or greater. This does not take into account any gaps.
						sim = a.getSimilarity();
	// The alignment score is the sum of activity similarity score for aligned activities and is decreased by the cost of a gap opening or gap extension whenever
	// the alignment contains a gap on either or both sequences.
					else
						sim = a.calculateScore();				
					if (sim == 0)
						dd[i][j] = 1d;				
					else
						dd[i][j] = 1d / sim;
	// Forcing dd to be symmetrical
					dd[j][i] = dd[i][j];
					System.out.print(".");
				}
			} else {
				for (int j = 0; j < sequences.size(); j++) {
					TreeMap<Date, String> sequenceB = sequences.get(j);
					Alignment a = SmithWatermanGotoh.align(new Sequence(sequenceA.values().toArray(new String[0])), new Sequence(sequenceB.values().toArray(new String[0])), matrix, costGapOpen, costGapExtend);
					float sim;
					if (useSim)
	// The similarity is the number of matches of the aligned sequences. Similarity is increased for an exact match and for a similar match.
	// Similar match means a similarity score of the aligned activities of 0 or greater. This does not take into account any gaps.
						sim = a.getSimilarity();
	// The alignment score is the sum of activity similarity score for aligned activities and is decreased by the cost of a gap opening or gap extension whenever
	// the alignment contains a gap on either or both sequences.
					else
						sim = a.calculateScore();				
					if (sim == 0)
						dd[i][j] = 1d;				
					else
						dd[i][j] = 1d / sim;
					System.out.print(".");
				}
			}
			i++;
			System.out.println();
		}

		getAck("Created trace dissimilarity matrix");

		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter(fname("simMatrix", "csv")));
			for (TreeMap<Date, String> sequence : sequences) {
				bw.write("\"X" + log.getCaseIDsForSequence(sequence).get(0) + "\", ");
			}
			bw.write("\b\b\n");
			for (int c=0;c<dd.length;c++) {
				for(int r=0;r<dd.length;r++) {
					bw.write(String.format("%.3f", dd[r][c]));
					if (r==dd.length-1) {
						bw.write("\n");
					} else
						bw.write(", ");
				}
			}
			bw.close();
		} catch (IOException e) {
			;
		}
		
		getAck("Written R matrix to " + fname("simMatrix", "csv"));

		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter(fname("alignCluster", "R")));
			bw.write("set.seed(2) \n");
			bw.write("s <- read.csv(\"" + fname("simMatrix", "csv") + "\") \n");
			bw.write("s <- s[, 1:(ncol(s)-1)] \n");
			bw.write("sm <- as.matrix(s) \n");
			bw.write("colnames(sm) <- names(s) \n");
			bw.write("rownames(sm) <- names(s) \n");
			switch (numDimensions) {
				case -1 : { bw.write("mds <- cmdscale(sm, k=ceiling(sqrt(ncol(sm))) ) \n"); break; }
				case -2 : { bw.write("mds <- cmdscale(sm, k=ceiling(log10(ncol(sm))) ) \n"); break; }
				case -3 : { bw.write("mds <- cmdscale(sm, k=ceiling(log(ncol(sm))) ) \n"); break; }
				case -4 : { bw.write("mds <- cmdscale(sm, k=ceiling(log2(ncol(sm))) ) \n"); break; }
				default : { bw.write("mds <- cmdscale(sm, k=ceiling("+numDimensions+") ) \n"); break; }
			}
			bw.write("clusters <- kmeans(mds, " + numClusters + ", nstart=25, iter.max=25) \n");
			bw.write("for (c in 1:" + numClusters + ") { \n");
			bw.write("	write(names(clusters$cluster[clusters$cluster==c]), file=paste(\"C\", c, \"_" + fname("cluster", "txt") + "\", sep=\"\")) \n");
			bw.write("} \n");
			bw.close();
		} catch (IOException e) {
			;
		}
		
		getAck("Written R script to " + fname("alignCluster", "R"));

		try {
			Process p = new ProcessBuilder("R", "CMD", "BATCH", "--vanilla", fname("alignCluster", "R"), fname("alignCluster", "output.txt")).start();
			p.waitFor();
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}

		getAck("Run R and written clusters to files " + fname("CX_", "txt") + " and output to " + fname("alignCluster", "output.txt"));
		
		// Cluster 0 is all traces in the log, as a reference for the subsequent mining algorithms
		// writeCluster0(log);
		
		for (int c=0; c<=numClusters; c++)
			writeXES(c, log);

		getAck("Written clusters to XES");
	
		for (int c=1; c<=numClusters; c++) {
			write_prom_script(c);
		}
		
		getAck("Written ProM scripts to file");

		for (int c=1; c<=numClusters; c++) {
			String[]	l = { "-f", "C" + c + fname("_ProMScript", "txt") };
			try {
				org.processmining.contexts.cli.CLI.main( l );
			} catch (Throwable e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		getAck("Finished running ProM scripts");

		System.out.println("Done."); System.out.flush();
		System.exit(0);
	}
*/
	private static void write_prom_script(int c) {
		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter("C" + c + fname("_ProMScript", "txt")));
			appendScriptFragment(bw, "prom_script_fragment1.txt");
			
			bw.write("int c = "+c+";\n");
			bw.write("int numClusters = "+numClusters+";\n");
			bw.write("boolean penalizeImproperCompletion = "+penalizeImproperCompletion+";\n");
			bw.write("boolean forceSymmetry = " + forceSymmetry + ";\n");
			bw.write("int numDimensions = " + numDimensions + ";\n");
			bw.write("boolean useSim = " + useSim + ";\n");
			bw.write("float mismatchPenaltyRelative = " + mismatchPenaltyRelative + "f;\n");
			bw.write("float costGapOpenRelative = " + costGapOpenRelative + "f;\n");
			bw.write("float costGapExtendRelative = " + costGapExtendRelative + "f;\n\n");

			appendScriptFragment(bw, "prom_script_fragment2.txt");
			if (miner.equalsIgnoreCase("IMi")) {
				bw.write("Object[] result = mine_petri_net_with_inductive_miner_with_parameters(log, new MiningParametersIMi());\n");
				bw.write("System.out.println(\"Mined petri nets using IMi (Inductive Miner infrequent) with default frequency threshold \" + new MiningParametersIMi().getNoiseThreshold());\n\n");
			} else 	{
				if (miner.equalsIgnoreCase("IM")) {
					bw.write("Object[] result = mine_petri_net_with_inductive_miner_with_parameters(log, new MiningParametersIM());\n");
					bw.write("System.out.println(\"Mined petri nets using IMi (Inductive Miner)\");\n\n");
				} else {
					bw.write("HeuristicsMinerSettings heuristicssettings = new HeuristicsMinerSettings();\n");
					bw.write("heuristicssettings.setClassifier( classifierList.get(0));\n");
					bw.write("FlexibleHeuristicsMiner fhm = new FlexibleHeuristicsMiner(new CLIPluginContext(new CLIContext(), \"plugin\"), log, summary, heuristicssettings);\n");
					bw.write("HeuristicsNet hn = fhm.mine();\n");
					bw.write("result = convert_heuristics_net_into_petri_net(hn);\n\n");
				}
			}
			appendScriptFragment(bw, "prom_script_fragment3.txt");
			bw.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void writeCluster0(EventLog log) {
		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter("cluster0.txt"));
			for (String t : log.getTraceIDs()) {
		        bw.write("X" + t + "\n");				
			}
	        bw.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
	}
	
	private static void writeXES(int c, EventLog log) {
		String inFName = "C" + c + "_" + fname("cluster", "txt");
		String outFName = "C" + c + "_" + fname("cluster", "xes");

		SimpleDateFormat simpleFormat = (SimpleDateFormat) DateFormat.getDateInstance();
        simpleFormat.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

        System.out.println("Writing cluster " + c + " to XES");
        
		try {
			BufferedReader br = new BufferedReader(new FileReader(inFName));
			BufferedWriter bw = new BufferedWriter(new FileWriter(outFName));

			bw.write("<log xes.version=\"1.0\" openxes.version=\"1.0RC7\" xes.features=\"nested-attributes\">\n");
			bw.write(" <extension name=\"Lifecycle\" prefix=\"lifecycle\" uri=\"http://www.xes-standard.org/lifecycle.xesext\"/>\n");
			bw.write(" <extension name=\"Organizational\" prefix=\"org\" uri=\"http://www.xes-standard.org/org.xesext\"/>\n");
			bw.write(" <extension name=\"Time\" prefix=\"time\" uri=\"http://www.xes-standard.org/time.xesext\"/>\n");
			bw.write(" <extension name=\"Concept\" prefix=\"concept\" uri=\"http://www.xes-standard.org/concept.xesext\"/>\n");
			bw.write(" <extension name=\"Semantic\" prefix=\"semantic\" uri=\"http://www.xes-standard.org/semantic.xesext\"/>\n");
			bw.write(" <global scope=\"trace\">\n");
			bw.write("   <string key=\"concept:name\" value=\"__INVALID__\"/>\n");
			bw.write(" </global>\n");
			bw.write(" <global scope=\"event\">\n");
			bw.write("  <string key=\"concept:name\" value=\"__INVALID__\"/>\n");
			bw.write("  <string key=\"lifecycle:transition\" value=\"complete\"/>\n");
			bw.write(" </global>\n");
			bw.write(" <classifier name=\"MXML Legacy Classifier\" keys=\"concept:name lifecycle:transition\"/>\n");
			bw.write(" <classifier name=\"Event Name\" keys=\"concept:name\"/>\n");
			bw.write(" <classifier name=\"Resource\" keys=\"org:resource\"/>\n");
			bw.write(" <string key=\"source\" value=\"AlignmentCluster\"/>\n");
			bw.write(" <string key=\"concept:name\" value=\"" + "Cluster " + c + "\"/>\n");
			bw.write(" <string key=\"description\" value=\"Result of Alignment Clustering\"/>\n");
			bw.write(" <string key=\"lifecycle:model\" value=\"standard\"/>\n");
			
			String line = br.readLine();
	        while (line != null) {
	        	String traceID = line.substring(1);
	        	bw.write(" <trace>");
	        	bw.write("  <string key=\"concept:name\" value=\"" + traceID + "\"/>\n");
	        	System.out.print("Writing " + traceID + " ");
	        	TreeMap<Date, String> trace = log.getTraceByID(traceID);
	        	for (Date d : trace.keySet()) {
	        		String s = trace.get(d);
	        		bw.write("   <event>\n");
        			bw.write("    <date key=\"time:timestamp\" value=\"" + simpleFormat.format(d) + "\"/>\n");
	        		bw.write("    <string key=\"concept:name\" value=\"" + s + "\"/>\n");
	        		bw.write("    <string key=\"lifecycle:transition\" value=\"complete\"/>\n");
	        		bw.write("   </event>\n");
	        		System.out.print(".");
	        	}
	        	bw.write("  </trace>\n");
	        	System.out.println();
	        	line = br.readLine();
	        }
	        bw.write("</log>\n");
	        bw.close();
	        br.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	private static void writeMXML(String fname, EventLog log) {
		String inFName = fname + ".txt";
		String outFName = fname + ".mxml";

		SimpleDateFormat simpleFormat = (SimpleDateFormat) DateFormat.getDateInstance();
        simpleFormat.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

        System.out.println("Writing cluster " + fname + " to MXML");
        
		try {
			BufferedReader br = new BufferedReader(new FileReader(inFName));
			BufferedWriter bw = new BufferedWriter(new FileWriter(outFName));

			bw.write("<WorkflowLog xsi:noNamespaceSchemaLocation=\"http://is.tm.tue.nl/research/processmining/WorkflowLog.xsd\"> \n");
			bw.write(" <Source program=\"AlignmentCluster\"/>\n");
			bw.write(" <Process id=\"" + fname + "\" description=\"Result of Alignment Clustering\">\n");

			String line = br.readLine();
	        while (line != null) {
	        	String traceID = line.substring(1);
	        	bw.write("  <ProcessInstance id=\"" + traceID + "\">\n");
	        	System.out.print("Writing " + traceID + " ");
	        	TreeMap<Date, String> trace = log.getTraceByID(traceID);
	        	for (Date d : trace.keySet()) {
	        		String s = trace.get(d);
	        		bw.write("   <AuditTrailEntry>\n");
	        		bw.write("    <WorkflowModelElement>" + s + "</WorkflowModelElement>\n");
	        		bw.write("    <EventType>complete</EventType>\n");
        			bw.write("    <Timestamp>" + simpleFormat.format(d) + "</Timestamp>\n");
	        		bw.write("   </AuditTrailEntry>\n");
	        		System.out.print(".");
	        	}
	        	bw.write("  </ProcessInstance>\n");
	        	System.out.println();
	        	line = br.readLine();
	        }
	        bw.write(" </Process>\n");
	        bw.write("</WorkflowLog>\n");
	        bw.close();
	        br.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
	private static void appendScriptFragment(BufferedWriter bw, String fname) {
		BufferedReader br;
		try {
			br = new BufferedReader(new InputStreamReader(SWGTest.class.getResource(fname).openStream()));
	        String line = br.readLine();
	        while (line != null) {
	        	bw.append(line + "\n");
		        line = br.readLine();
			}
	        br.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private static void getAck(String message) {
		try {
			System.out.println(message);
			if (!automated) {
				System.out.flush();
				System.out.print("> "); 
				System.out.flush();
				System.in.read();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	private static String fname(String stem, String extension) {
		String fname = new String(stem);
		fname = fname + "k" + numClusters;
		if (penalizeImproperCompletion)
			fname = fname + "penalizeImproperCompletion";
		if (forceSymmetry)
			fname = fname + "forceSymmetry";
		switch (numDimensions) {
			case -1 : { fname = fname + "Sqrt"; break; }
			case -2 : { fname = fname + "Log10"; break; }
			case -3 : { fname = fname + "Log"; break; }
			case -4 : { fname = fname + "Log2"; break; }
			default : { fname = fname + "Dim"+numDimensions; break; }
		}
		if (useSim)
			fname = fname + "useSimilarity";
		fname = fname + "mPR" + mismatchPenaltyRelative + "cGOR" + costGapOpenRelative + "cGER" + costGapExtendRelative;
		fname = fname + "." + extension;
		return fname;
	}

}