package ca.evermann.joerg.blockchainWFMS.CA;

import bftsmart.reconfiguration.util.Configuration;
import bftsmart.tom.util.ECDSAKeyPairGenerator;
import bftsmart.tom.util.RSAKeyPairGenerator;

public class CertificateAuthority {
	
	public static void generatePeerInfo(Integer nodeId) {
	}
	
	public static void main(String[] args) {
		if (args.length == 1) {
			try {
				Configuration conf = new Configuration(Integer.parseInt(args[0]), null);
				
                if (conf.getSignatureAlgorithm().toLowerCase().contains("ecdsa")) {	
					// parameters are nodeId and EC curve spec
					ECDSAKeyPairGenerator.main(new String[] {args[0], "secp256k1"});
                } else if (conf.getSignatureAlgorithm().toLowerCase().contains("rsa")) {
					// parameters are nodeId and key length
					RSAKeyPairGenerator.main(new String[] {args[0], "512"});
                } else {
                	System.err.println("Unknown signature algorithm, cannot create keys");
                	System.exit(-1);
                }
				System.out.println("Generated key pair for node "+args[0]);
				System.exit(0);
			} catch (Exception e) {
				System.err.println(e.getMessage());
				System.exit(-1);
			}
		} else {
			System.err.println("Failed to specify node Id");
			System.exit(-1);
		}
	}

}
