package ca.evermann.joerg.blockchainWFMS.CA;

import java.io.*;
import java.security.*;
import java.util.Base64;

public class CryptoUtils {

	protected static final String CAPublicKeyFileName = "CAPublic.key";
	
	public static byte[] hashObject(Serializable obj) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos;
        if (obj==null) {
        	return null;
        }
		try {
			oos = new ObjectOutputStream( baos );
	        oos.writeObject(obj);
	        oos.close();
		} catch (IOException e) {
			System.err.println("IO Error when hashing");
			return null;
		}
        byte[] content = baos.toByteArray();
        MessageDigest md;
        try {
        	md = MessageDigest.getInstance("SHA-512");
        } catch (NoSuchAlgorithmException e) {
        	System.err.println("No such algorithm when hashing");
        	return null;
        }
        return md.digest(content);
	}
	
	public static byte[] signObject(Serializable obj, PrivateKey key, String signatureAlgorithm) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos;
        if (obj==null || key==null) {
        	return null;
        }
		try {
			oos = new ObjectOutputStream( baos );
	        oos.writeObject(obj);
	        oos.close();
	        String content = Base64.getEncoder().encodeToString(baos.toByteArray());
			try {
				Signature sig = Signature.getInstance(signatureAlgorithm);
				sig.initSign(key);
				sig.update(content.getBytes());
				byte[] sigbytes = sig.sign();
				return sigbytes;
			} catch (NoSuchAlgorithmException e) {
				System.err.println("No such signature algorithm");
			} catch (InvalidKeyException e) {
				System.err.println("Invalid key");
			} catch (SignatureException e) {
				System.err.println("Signature exception");
			}
			return null;
		} catch (IOException e) {
			System.err.println("IO Error in signObject");
			return null;
		}
	}

	public static boolean verifyObjectSignature(Serializable obj, byte[] signature, PublicKey key, String signatureAlgorithm) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos;
        if (obj==null || key==null || signature==null) {
        	return false;
        }
		try {
			oos = new ObjectOutputStream( baos );
	        oos.writeObject(obj);
	        oos.close();
	        String content = Base64.getEncoder().encodeToString(baos.toByteArray());
			try {
				Signature sig = Signature.getInstance(signatureAlgorithm);
				sig.initVerify(key);
				sig.update(content.getBytes());
				return sig.verify(signature);
			} catch (NoSuchAlgorithmException e) {
				System.err.println("No such signature algorithm");
			} catch (InvalidKeyException e) {
				System.err.println("Invalid key");
			} catch (SignatureException e) {
				System.err.println("Signature exception");
			}
			return false;
		} catch (IOException e) {
			System.err.println("IO Error in signObject");
			return false;
		}
	}

	
}
