package ca.evermann.joerg.blockchainWFMS.CA;

import java.io.Serializable;
import java.security.PublicKey;

public class PeerCertificate implements Serializable {
	private String host;
	private int port;
	private PublicKey key;
	private int repId;
	
	public PeerCertificate(String host, int port, PublicKey pubKey, int repId) {
		this.host = host;
		this.port = port;
		this.key = pubKey;
		this.repId = repId;
	}
	
	public String getHost() {
		return host;
	}
	public int getPort() {
		return port;
	}
	public PublicKey getKey() {
		return key;
	}
	public int getRepId() {
		return repId;
	}
	
	@Override
	public boolean equals(Object other) {
		if (other instanceof PeerCertificate) {
			return this.host.equals(((PeerCertificate) other).getHost()) && 
					this.port==((PeerCertificate) other).getPort() && 
					this.key.equals(((PeerCertificate) other).getKey()) &&
					this.repId==((PeerCertificate) other).getRepId();
		} else {
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return java.util.Objects.hash(host, port, key, repId);
	}
	
	@Override
	public String toString() {
		return "[" + repId + "] " + host + ":" + port;
	}
}

