package ca.evermann.joerg.blockchainWFMS.PetriNet;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.TreeSet;

public class ActivitySpec implements Serializable {

	private String		role;
	private	String		host;
	private	Integer		port;
	
	private TreeSet<String>	inputs;
	private TreeSet<String>	outputs;
	private String			execClass;
	private String			execMethod;
	
	public ActivitySpec(String role, String host, Integer port, TreeSet<String> inputs, TreeSet<String> outputs, String execClass, String execMethod) {
		this.role = role;
		this.host = host;
		this.port = port;
		this.inputs = inputs;
		this.outputs = outputs;
		this.execClass = execClass;
		this.execMethod = execMethod;
	}
	
	ActivitySpec() {
		super();
		role = "";
		host = "";
		port = 0;
		execClass = "";
		execMethod = "";
		inputs = new TreeSet<String>();
		outputs = new TreeSet<String>();
	}
	
	public String getExecClass() {
		return execClass;
	}
	public void setExecClass(String buffer) {
		this.execClass = buffer;
	}
	public String getExecMethod() {
		return execMethod;
	}
	public void setExecMethod(String buffer) {
		this.execMethod = buffer;
	}
	public String getRole() {
		return role;
	}
	public void setRole(String role) {
		this.role = role;
	}
	public String getHost() {
		return host;
	}
	public void setHost(String host) {
		this.host = host;
	}
	public Integer getPort() {
		return port;
	}
	public void setPort(Integer port) {
		this.port = port;
	}
	public TreeSet<String> getInputs() {
		return inputs;
	}
	public void setInputs(TreeSet<String> inputs) {
		this.inputs = inputs;
	}
	public TreeSet<String> getOutputs() {
		return outputs;
	}
	public void setOutputs(TreeSet<String> outputs) {
		this.outputs = outputs;
	}

	public void writeToFile(PrintWriter out) {
		out.println("\t\t\t<Host>"+host+"</Host>");
		out.println("\t\t\t<Port>"+port.toString()+"</Port>");
		out.println("\t\t\t<Role>"+role+"</Role>");
		if (inputs.size() > 0) {
			out.println("\t\t\t<Inputs>");
			for (String input : inputs) {
				out.println("\t\t\t\t<Input>" + input + "</Input>");
			}
			out.println("\t\t\t</Inputs>");
		}
		if (outputs.size() > 0) {
			out.println("\t\t\t<Outputs>");
			for (String output : outputs) {
				out.println("\t\t\t\t<Output>" + output + "</Output>");
			}
			out.println("\t\t\t</Outputs>");
		}
		if (execClass.length() != 0 && execMethod.length() != 0) {
			out.println("\t\t\t<Execute>");
			out.println("\t\t\t\t<ExecClass>" + execClass + "</ExecClass>");
			out.println("\t\t\t\t<ExecMethod>" + execMethod + "</ExecMethod>");
			out.println("\t\t\t</Execute>");
		}
	}

	
}
