package ca.evermann.joerg.blockchainWFMS.PetriNet;

import java.io.PrintWriter;
import java.io.Serializable;

public class Transition implements Serializable, Comparable<Transition> {

	private String name;
	private ActivitySpec activity;
	
	public Transition(String name) {
		this.setName(name);
		this.setActivity(null);
	}

	public ActivitySpec getActivity() {
		return activity;
	}

	public void setActivity(ActivitySpec activity) {
		this.activity = activity;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public String toString() {
		return new String("Transition "+this.name);
	}
	
	@Override
	public int hashCode() {
		return name.hashCode();
	}
	
	@Override
	public boolean equals(Object other) {
		if (other == null) return false;
		if (this == other) return true;
		if (getClass() != other.getClass()) return false;
		return this.hashCode() == other.hashCode();
	}
	
	@Override
	public int compareTo(Transition other) {
		if (other == null) return -1;
		if (this == other) return 0;
		if (getClass() != other.getClass()) return -1;
		return this.name.compareTo(other.name);
	}

	public void writeToFile(PrintWriter out) {
		out.println("\t\t<Transition name=\""+name+"\">");
		activity.writeToFile(out);
		out.println("\t\t</Transition>");
	}

}
