package ca.evermann.joerg.blockchainWFMS.chain;

import java.io.Serializable;
import java.util.Objects;

import ca.evermann.joerg.blockchainWFMS.CA.CryptoUtils;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainUtils;

public class Block implements Serializable, Comparable<Block> {

    private byte[] hash;
    private byte[] previousBlockHash;
    private Transaction transaction;
    private long sequence;

    public Block(byte[] previousBlockHash, Transaction transaction, long sequence) {
        this.previousBlockHash = previousBlockHash;
        this.transaction = transaction;
        this.sequence = sequence;
        this.hash = calculateHash();
    }

    public byte[] getHash() {
        return hash;
    }

    public String getHash64() {
    	return BlockChainUtils.to64(hash);
    }
    
    public byte[] getPreviousBlockHash() {
        return previousBlockHash;
    }

    public String getPreviousBlockHash64() {
    	return previousBlockHash==null?null:BlockChainUtils.to64(previousBlockHash);
    }
    
    public Transaction getTransaction() {
        return transaction;
    }

    public long getSequence() {
        return sequence;
    }

    /**
     * Calculates the hash using relevant fields of this type
     * @return SHA256-hash as raw bytes
     */
    public byte[] calculateHash() {
    	return CryptoUtils.hashObject(new Object[] {previousBlockHash, sequence} );
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Block block = (Block) o;
        return hash.equals(block.hash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(previousBlockHash, sequence);
    }

	@Override
	public String toString() {
		String s = new String(" Hash ").concat(this.getHash64());
		s = s.concat(" Seq " + sequence);
		if (this.previousBlockHash != null) {
			s = s.concat(" Prev ").concat(this.getPreviousBlockHash64());
		} else {
			s = s.concat(" Genesis ");
		}
		s = s.concat("\n").concat(transaction.toString());
		s.concat("\n");
		return s;
	}

	@Override
	public int compareTo(Block o) {
		return Long.compare(this.sequence, o.sequence);
	}
	
}
