package ca.evermann.joerg.blockchainWFMS.chain;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;

import javax.swing.JOptionPane;

import bftsmart.tom.ServiceProxy;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainUtils;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;

public class OrderingService {

	ServiceProxy serviceProxy;
	P2PNode node;
	
	public OrderingService(int clientId, P2PNode node) {
		this.node = node;
		serviceProxy = new ServiceProxy(clientId);
	}
	
	public boolean addTx(Transaction t) {
		try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
				ObjectOutput objOut = new ObjectOutputStream(byteOut);) {
			
			objOut.writeObject(OrderingServiceRequestType.ADD_TX);
			objOut.writeObject(t);
			objOut.flush();
			byteOut.flush();
			
			byte[] reply = serviceProxy.invokeOrdered(byteOut.toByteArray());
			// invokeOrdered throws a runtime exception if we don't get consensus
			// so, if we get here, we have consensus
			if (reply != null) {
				if (reply.length == 0)
					return false;
				try (ByteArrayInputStream byteIn = new ByteArrayInputStream(reply);
						ObjectInput objIn = new ObjectInputStream(byteIn)) {
					byte[] resultHash = (byte[]) objIn.readObject();
					// Check if we have the same last block hash in our blockservice
					// if not, we know that our ordering service is faulty/malicious
					// despite having consensus (ours is just the byzantine faulty node)
					// because the ordering service generates blocks, a faulty ordering
					// service compromises the block service as well as the workflow service
					// due to the way we coupled this.
					Block ourBranchHead = node.blockService.getMainBranchHead();					
					synchronized(node.blockService) {
						ourBranchHead = node.blockService.getMainBranchHead();
					}
					if ((ourBranchHead==null && resultHash==null))
						return true;
					if ( (ourBranchHead == null && resultHash != null) ||
						 (ourBranchHead != null && resultHash == null )) {
						System.err.println("[OrderingService] Local ordering service is faulty!");
						JOptionPane.showMessageDialog(null, "[OrderingService] Local ordering service is faulty!", "Error", JOptionPane.ERROR_MESSAGE);
						return false;
					}
					if (Arrays.equals(ourBranchHead.getHash(), resultHash))
						return true;
					else {
						System.err.println("[OrderingService] Local ordering service is faulty!");
						JOptionPane.showMessageDialog(null, "[OrderingService] Local ordering service is faulty!", "Error", JOptionPane.ERROR_MESSAGE);
						return false;
					}
				} catch (ClassNotFoundException e) {
					System.err.println("[OrderingService] ClassNotFoundException when adding transaction");
					return false;
				}
			} else {
				return false;
			}
		} catch (IOException e) {
			System.err.println("[OrderingService] IOException when adding transaction");
			return false;
		}
	}
	
	public byte[] getHead() {
		try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
				ObjectOutput objOut = new ObjectOutputStream(byteOut);) {
			
			objOut.writeObject(OrderingServiceRequestType.GET_HEAD);
			objOut.flush();
			byteOut.flush();
			
			byte[] reply = serviceProxy.invokeOrdered(byteOut.toByteArray());
			if (reply != null) {
				if (reply.length == 0)
					return null;
				try (ByteArrayInputStream byteIn = new ByteArrayInputStream(reply);
						ObjectInput objIn = new ObjectInputStream(byteIn)) {
					return (byte[]) objIn.readObject();
				} catch (ClassNotFoundException e) {
					System.err.println("[OrderingService] ClassNoFoundException when getting chain head");
					return null;
				}
			} else {
				return null;
			}
		} catch (IOException e) {
			System.out.println("[OrderingService] IOException when getting chain head");
		}
		return null;
	}
	
	public String getHead64() {
		byte[] hash = getHead();
		return hash==null ? null : BlockChainUtils.to64(hash);
	}
}
