package ca.evermann.joerg.blockchainWFMS.main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Base64;

import javax.tools.SimpleJavaFileObject;

public class BlockChainUtils {

	private static final Base64.Encoder b64enc = Base64.getEncoder();
	private static final Base64.Decoder b64dec = Base64.getDecoder();
	
	public static class JavaSourceFromString extends SimpleJavaFileObject {
		final String code;
	
		public JavaSourceFromString(String name, String code) {
			super(URI.create("string:///" + name.replace('.','/') + Kind.SOURCE.extension),Kind.SOURCE);
			this.code = code;
		}
	
		@Override
		public CharSequence getCharContent(boolean ignoreEncodingErrors) {
			return code;
		}
	}

	public static Serializable deepCopy(Serializable object) {
		if (object == null)
			return null;
		try {
			ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
			ObjectOutputStream outputStrm = new ObjectOutputStream(outputStream);
			outputStrm.writeObject(object);
			ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
			ObjectInputStream objInputStream = new ObjectInputStream(inputStream);
			return (Serializable)objInputStream.readObject();
		}
		catch (IOException | ClassNotFoundException e) {
			System.err.println("DeepCopy error");
			return null;
		}
	}
	
	public static String right(String s, int n) {
		if (n < 1) return "";
		return s.substring(s.length()-Math.min(n, s.length()), s.length());
	}
	
	public static String to64(byte[] b) {
		return b64enc.encodeToString(b);
	}
	
	public static byte[] from64(String s) {
		return b64dec.decode(s);
	}
}
