package ca.evermann.joerg.blockchainWFMS.main;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class BlockChainWFMSConfig {

	/*
	 * P2P Constants
	 * 
	 */
	/* Maximum number of connections per P2P node */
	public static int maxConnections = 2;
	
	/*
	 * Worklist User Interface related
	 */
	/* Width of text input fields in workitem dialog */
	public static int textFieldWidth = 20;

	/* Maximum number of blocks in queue from blockService to workflowEngine */
	public static int blockQueueSize = 5;
	
	/*
	 * difference from base TOM port
	 */
	public static int portDiff = 2;
	
	static {
        HashMap<String, String> configs = new HashMap<String, String>();
        try{
            String configHome="config";
            String sep = System.getProperty("file.separator");
            String path =  configHome+sep+"blockchain.config";;
            FileReader fr = new FileReader(path);
            BufferedReader rd = new BufferedReader(fr);
            String line = null;
            while((line = rd.readLine()) != null){
                if(!line.startsWith("#")){
                    StringTokenizer str = new StringTokenizer(line,"=");
                    if(str.countTokens() > 1){
                        configs.put(str.nextToken().trim(),str.nextToken().trim());
                    }
                }
            }
            fr.close();
            rd.close();
            
            String s = configs.remove("maxConnections");
            if(s == null){
                maxConnections = 2;
            }else{
                maxConnections = Integer.parseInt(s);
            }
            s = configs.remove("textFieldWidth");
            if(s == null){
                maxConnections = 20;
            }else{
                maxConnections = Integer.parseInt(s);
            }
            s = configs.remove("portDiff");
            if(s == null){
                maxConnections = 2;
            }else{
                maxConnections = Integer.parseInt(s);
            }

        }catch(Exception e){
        	System.err.println("Could not load blockchain configuration file. Using defaults.");
        }

	}

}
