package ca.evermann.joerg.blockchainWFMS.main;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import bftsmart.reconfiguration.ViewManager;
import ca.evermann.joerg.blockchainWFMS.chain.TestTransaction;
import ca.evermann.joerg.blockchainWFMS.chain.Transaction;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.TestMessage;

public class BlockChainWFMSUI extends JFrame {
	
	public JTextArea logTxt;
	
	public BlockChainWFMSUI(P2PNode node, JTextArea logTxt) {
		this.logTxt = logTxt;
		
		this.setTitle("BlockchainWFMS (Replica " + node.whoAmI() + ")");
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		this.setSize(600, 400);
		this.setMinimumSize(new Dimension(600, 400));
		
		Image icon;
		try {
			URL u = BlockChainWFMSUI.class.getResource("icons8-arbeitsablauf-80.png");
			icon = ImageIO.read(u);
			this.setIconImage(icon);
		} catch (IOException e) {
			// proceed without custom icon
		}
		
		JButton exitButton = new JButton("Exit");
		exitButton.addActionListener((ActionEvent event) -> {
			node.Shutdown();
			System.exit(0);
		});
		
		JButton msgButton = new JButton("Test Message");
		msgButton.addActionListener((ActionEvent event) -> {
			node.sendMessage(new TestMessage(node.whoAmI().getPort()));
		});
		
		JButton txButton = new JButton("Test Transaction");
		txButton.addActionListener((ActionEvent event) -> {
			Transaction t = new TestTransaction(new String("Hello Transaction"));
			t.setOriginator(node.whoAmI());
			node.signTransaction(t);
			node.addTransaction(t);
		});
		
		JButton printButton = new JButton("Print Status");
		printButton.addActionListener((ActionEvent event) -> {
			if (node.blockService != null)
				System.out.println(node.blockService.toString());
			if (node.orderingServiceServer != null)
				System.out.println(node.orderingServiceServer.toString());
		});
		
		JButton restartButton = new JButton("Restart BFT");
		restartButton.addActionListener((ActionEvent event) -> {
			node.restartBFT();
		});
		
		JLabel fLabel = new JLabel("New F: ");
		JTextField fTextField = new JTextField(2);

		JButton setFButton = new JButton("Set F");
		setFButton.addActionListener((ActionEvent event) -> {
			try {
				int newF = Integer.parseInt(fTextField.getText());
				int maxF = node.orderingServiceServer.getMaxF();
				if (newF <= maxF) {
			        ViewManager viewManager = new ViewManager("", null);
			        viewManager.setF(Integer.parseInt(fTextField.getText()));
			        viewManager.executeUpdates();		        
		        	viewManager.close();
				} else {
					JOptionPane.showMessageDialog(this, "Maximum F for N=" + node.orderingServiceServer.getCurrentN() + " nodes is "+maxF+" when BFT="+node.orderingServiceServer.isBFT(), "Cannot set new F", JOptionPane.INFORMATION_MESSAGE);
				}
				fTextField.setText("");
	        } catch (NumberFormatException e) {
	        	fTextField.setText("");
	        }
		});
		
	    JPanel firstRow = new JPanel();
        firstRow.add(exitButton);
        firstRow.add(msgButton);
        firstRow.add(txButton);
        firstRow.add(printButton);

	    JPanel secRow = new JPanel();
        secRow.add(restartButton);
        secRow.add(fLabel);
        secRow.add(fTextField);
        secRow.add(setFButton);
        
		JScrollPane txtScroll = new JScrollPane(this.logTxt);
		txtScroll.setMinimumSize(new Dimension(500, 300));
		
	    Container pane = getContentPane();
        pane.setLayout(new BoxLayout(pane, BoxLayout.PAGE_AXIS));
        pane.add(firstRow);
        pane.add(secRow);
        pane.add(txtScroll);

	}

}
