package ca.evermann.joerg.blockchainWFMS.main;

import java.awt.EventQueue;
import java.io.PrintStream;

import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;

public class BlockchainWFMS {

	public static JTextArea logTxt;
	
	public static void setupLogText() {
		logTxt = new JTextArea(50, 130);
		logTxt.setEditable(false);
		logTxt.setAutoscrolls(true);
		DefaultCaret caret = (DefaultCaret)logTxt.getCaret();
		caret.setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
		PrintStream out = new PrintStream(new JTextAreaOutputStream(logTxt));
		System.setOut(out);
		System.setErr(out);
	}
	
	public static void main(String[] args) {
		int replicaNum = 0;
		setupLogText();
		
		if (args.length < 1) {
			System.err.println("Must provide your replica number, your hostname and listening port");
			System.exit(-1);
		}

		try {
			replicaNum = Integer.parseInt(args[0]);
		} catch (NumberFormatException e) {
			System.err.println("First argument must be integer");
			System.exit(-1);
		}

		P2PNode	myP2PNode = new P2PNode(replicaNum);	
		EventQueue.invokeLater(() -> {
			BlockChainWFMSUI ex = new BlockChainWFMSUI(myP2PNode, logTxt);
			ex.setVisible(true); 
		});

		myP2PNode.init(replicaNum);
	}

}
