package ca.evermann.joerg.blockchainWFMS.p2p;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockRequestMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockSendMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainRequestMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainSendMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.Message;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.TestMessage;

public class InboundMsgHandler implements Runnable {

	private P2PNode node;

	public Boolean stop;

	public InboundMsgHandler(P2PNode node) {
		this.node = node;
		this.stop = false;
	}
	
	@Override
	public void run() {
		while (!stop) {
			for (BlockingQueue<Message> q : node.getInboundQueues()) {
				Message msg;
				try {
					msg = q.poll(500, TimeUnit.MILLISECONDS);
				} catch (InterruptedException e) {
					System.err.println("Interrupted inbound message take");
					break;
				}
				if (msg != null) {
					if (!msg.getSender().equals(node.whoAmI())) {
						if (msg.verifyContent()) {
							System.err.print("Received : ");
							switch (msg.getClass().getName()) {
							case "ca.evermann.joerg.blockchainWFMS.p2p.messages.Message":
								System.err.println("Message (abstract and should be subclassed)");
								break;
							case "ca.evermann.joerg.blockchainWFMS.p2p.messages.TestMessage":
								TestMessage test = (TestMessage) msg;
								System.err.println("Received: " + test.toString());
								break;
							case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockRequestMessage":
								BlockRequestMessage getBlockMsg = (BlockRequestMessage) msg;
								System.err.println("Received: " + getBlockMsg.toString());
								node.sendBlockTo(getBlockMsg.getSender(), getBlockMsg.getBlockHash());
								break;
							case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockSendMessage":
								BlockSendMessage bMsg = (BlockSendMessage) msg;
								System.err.println("Received: " + bMsg.toString());
								node.receiveBlock(bMsg);
								break;
							case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainRequestMessage":
								BlockchainRequestMessage getBlockchainMsg = (BlockchainRequestMessage) msg;
								System.err.println("Received: " + getBlockchainMsg.toString());
								node.sendBlockchainTo(getBlockchainMsg.getSender(), getBlockchainMsg.lowerHash(), getBlockchainMsg.upperHash());
								break;
							case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainSendMessage":
								BlockchainSendMessage bcMsg = (BlockchainSendMessage) msg;
								System.err.println("Received: " + bcMsg.toString());
								node.receiveBlockChain(bcMsg);
								break;									
							default:
								System.err.println("Unknown message received");
								break;
							}
						} else {
							System.err.println("Message with unverified content received");
						}
					} else {
						System.err.println("Message to self received, ignoring");
					}
				}
			}
		}
	}

}
