package ca.evermann.joerg.blockchainWFMS.p2p;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.BlockingQueue;

import ca.evermann.joerg.blockchainWFMS.p2p.messages.Message;

public class InboundQueueHandler implements Runnable {

	public Boolean stop;
	private BlockingQueue<Message> inboundQueue;
	protected ObjectInputStream inStream;
	
	public InboundQueueHandler(BlockingQueue<Message> inboundQueue, ObjectInputStream inStream) {
		this.inboundQueue = inboundQueue;
		this.inStream = inStream;
		this.stop = false;
	}
	
	@Override
	public void run() {
		while (!stop) {
			Message inmsg = null;
			try {
				inmsg = (Message) inStream.readObject();
			} catch (IOException e) {
				break;
			} catch (ClassNotFoundException e) {
				System.err.println("Unknown class has arrived");
				continue;
			}
			try {
				inboundQueue.put(inmsg);
			} catch (InterruptedException e) { 
				System.err.println("Interrupted while putting object in queue");
				continue;
			}
		}
	}

}
