package ca.evermann.joerg.blockchainWFMS.p2p;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class OutboundConnection extends PeerConnection implements Runnable {

	public OutboundConnection(InetSocketAddress otherAddress, int myReplicaId, OutboundServer server) {
		super(myReplicaId, server);

		try {
			this.socket = new Socket();
			this.socket.connect(otherAddress, 5000);
			if (!this.socket.isConnected()) {
				System.err.println("Outbound socket connect timeout");
				this.stop = true;
			}
		} catch (IOException e) {
			this.stop = true;
		}
	}
	
	
}
