package ca.evermann.joerg.blockchainWFMS.p2p;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;

import ca.evermann.joerg.blockchainWFMS.CA.PeerCertificate;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainWFMSConfig;

public class OutboundServer extends NodeServer implements Runnable {

	protected ArrayList<PeerCertificate> availableHosts;
	
	@SuppressWarnings("unchecked")
	public OutboundServer(P2PNode myNode) throws IOException {
		super(myNode);
		
		availableHosts = (ArrayList<PeerCertificate>) myNode.getPeers().clone();
		Collections.shuffle(this.availableHosts);
	}
	
	@Override
	public void run() {
		while (!stop) {
			if (availableHosts.size() > 0) {

				PeerCertificate host;
				synchronized(availableHosts) {
					host = availableHosts.get(0);
					availableHosts.remove(0);
				}

				if (host.equals(node.whoAmI()))
					continue;
				
				InetAddress otherAddr;
				try { 
					otherAddr = InetAddress.getByName(host.getHost());
				} catch (UnknownHostException e) {
					System.err.println("Cannot resolve host" + e.getMessage());
					continue;
				}
				Integer otherPort = host.getPort();				
				InetSocketAddress otherSocketAddr = new InetSocketAddress(otherAddr, otherPort);

				if (node.activeConnections.size() < BlockChainWFMSConfig.maxConnections) {
					if (!node.activeConnections.containsKey(host)) {
						OutboundConnection cw = new OutboundConnection(otherSocketAddr, node.whoAmI().getRepId(), this);
						if (cw.OpenAndVerify(node.outboundQueues.size()==0?true:false)) {
							// Joining the view must be initiated from the corresponding inbound server, as that has a ServerViewController
							// This node may be still be waiting for the TOMService to be initiated
							synchronized(node.inboundQueues) {
								node.outboundQueues.put(cw.getOtherCertificate(), cw.getOutboundQueue());
								node.inboundQueues.add(cw.getInboundQueue());
								node.activeConnections.put(host, cw);
								Thread t = new Thread(cw, "Connection worker for " + cw.getOtherCertificate().getHost()+":"+cw.getOtherCertificate().getPort());
								t.start();
								System.out.println("Outgoing connection to " + cw.getOtherCertificate().getHost()+":"+cw.getOtherCertificate().getPort());
							}
						} else {
							cw.shutdown();
						}
					}
				} else {
					synchronized(availableHosts) {
						availableHosts.add(host);
					}
				}
			}
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				System.err.println("Interrupted during sleep");
				continue;
			}
		}
		
	    for (PeerConnection ow : node.activeConnections.values()) {
	    	ow.stop = true;
	    }
	}
}
