package ca.evermann.joerg.blockchainWFMS.p2p.messages;

import ca.evermann.joerg.blockchainWFMS.main.BlockChainUtils;

public class BlockchainRequestMessage extends Message {

	private byte[]	lowerHash, upperHash;
	
	public BlockchainRequestMessage(byte[] lowerHash, byte[] upperHash) {
		super();
		this.lowerHash = lowerHash;
		this.upperHash = upperHash;
	}
	
	public byte[] upperHash() {
		return upperHash;
	}
	
	public byte[] lowerHash() {
		return lowerHash;
	}
	
	public String toString() {
		return "BlockchainRequestMessage with lowerHash: "+((lowerHash==null)?"null":BlockChainUtils.to64(lowerHash))+" upperHash: "+BlockChainUtils.to64(upperHash);
	}

}
