package ca.evermann.joerg.blockchainWFMS.p2p.messages;

import java.io.Serializable;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;

import ca.evermann.joerg.blockchainWFMS.CA.CryptoUtils;
import ca.evermann.joerg.blockchainWFMS.CA.PeerCertificate;

public abstract class Message implements Serializable {
	
	private final UUID uuid = UUID.randomUUID();
	private PeerCertificate sender;
	private byte[] signature;
	private String signatureAlgorithm;
	private long timestamp;
	public Serializable payload = new Integer(0);

	public Message() {
		this.timestamp = System.currentTimeMillis();
	}
	
	public void setSender(PeerCertificate sender) { this.sender = sender; }
	public PeerCertificate getSender() { return sender; }

	public void signContent(PrivateKey key, String signatureAlgorithm) {
		this.signature = CryptoUtils.signObject(new Object[] {sender, payload, timestamp}, key, signatureAlgorithm);
		this.signatureAlgorithm = signatureAlgorithm;
	}

	public byte[] getSignature() {
		return signature;
	}
	
	public boolean verifyContent() {
		if (payload == null || signature == null || sender == null) {
			return false;
		}
		return CryptoUtils.verifyObjectSignature( new Object[] {sender, payload, timestamp}, signature, sender.getKey(), signatureAlgorithm);
	}
	
	public UUID getID() {
		return uuid;
	}
	
	public long getTimestamp() {
	    return timestamp;
	}
	
	public byte[] getHash() {
		return CryptoUtils.hashObject(new Object[] {sender, payload, timestamp} );
	}
	
	@Override
	public int hashCode() {
		return Objects.hash(sender, payload, timestamp);
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null) return false;
		if (this == obj) return true;
		if (getClass() != obj.getClass()) return false;
		return this.hashCode() == obj.hashCode();
	}
	
	@Override
	public String toString() {
		String s = new String("  Msg UUID ");
		s.concat(uuid.toString()).concat("  sender ").concat(sender.toString()).concat("  timestamp ").concat(Long.toString(timestamp)).concat("  payload ").concat(this.payload.getClass().toString());
		return s;
	}
	
}
