package ca.evermann.joerg.blockchainWFMS.testing;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import ca.evermann.joerg.blockchainWFMS.PetriNet.PetriNet;
import ca.evermann.joerg.blockchainWFMS.chain.TestTransaction;
import ca.evermann.joerg.blockchainWFMS.chain.Transaction;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;
import ca.evermann.joerg.blockchainWFMS.workflow.transactions.ModelDefinitionTransaction;

public class BlockchainWFMSTest {
	
	private int nTests = 100;
	private int nThreads = 4;
	private P2PNode	myP2PNode;
	private String fname = "example.bws";
	
	private BlockchainWFMSTest(P2PNode node) {
		myP2PNode = node;
	}
	
	private int padTx() {
		int i=0;
		Transaction t;
		for (i=0; i<nThreads; i++) {
			t = new TestTransaction("Hello");
			t.setOriginator(myP2PNode.whoAmI());
			myP2PNode.signTransaction(t);
			myP2PNode.addTransaction(t);			
		}
		return i;
	}
	
	private void runTest() {
		
		int txCount = 0;
		long startTime, endTime;
		
		PetriNet pn = new PetriNet("");
		pn.readFromFile(fname);
		Transaction t = new ModelDefinitionTransaction(pn);
		t.setOriginator(myP2PNode.whoAmI());
		myP2PNode.signTransaction(t);
		myP2PNode.addTransaction(t);
		padTx();

		ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
		int[] resultPool = new int[nTests];
		
		startTime = System.currentTimeMillis();
		System.out.println("Starting test at: " + startTime);
		
		for (int i=0; i<nTests; i++) {
			threadPool.execute(new TestRunner(myP2PNode, pn, i, resultPool));			
		}
		threadPool.shutdown();
		while (!threadPool.isTerminated()) {
			try {
				threadPool.awaitTermination(1, TimeUnit.SECONDS);
			} catch (InterruptedException e) { }
		}
		endTime = System.currentTimeMillis();
		
		for (int i=0; i<resultPool.length; txCount+=resultPool[i++]); 
		System.out.println("Ending test at: " + endTime);
		System.out.println("Transaction count: " + txCount);
		System.out.println("Tps: " + 1000f*txCount/(endTime-startTime));
	}
	
	public static void main(String[] args) {
		int replicaNum = 0;
		boolean generate = false;
		
		if (args.length < 2) {
			System.err.println("Must provide your replica number and whether to generate Tx");
			System.exit(-1);
		}

		try {
			replicaNum = Integer.parseInt(args[0]);
		} catch (NumberFormatException e) {
			System.err.println("First argument must be integer");
			System.exit(-1);
		}

		generate = Boolean.parseBoolean(args[1]);	

		P2PNode myP2PNode = new P2PNode(replicaNum);
		myP2PNode.init(replicaNum);
		if (generate) {
			System.out.println("Press any key to start generating Tx.");
			try {
				System.in.read();
			} catch (IOException e) {
				e.printStackTrace();
			}
			BlockchainWFMSTest test = new BlockchainWFMSTest(myP2PNode);
			test.runTest();
			System.out.println("Test done. Press a key to end.");
			try {
				System.in.read();
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			System.out.println("Not generating Tx. Press a key to end.");
			try {
				System.in.read();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		
		myP2PNode.Shutdown();
		System.exit(0);		
	}

}
