package ca.evermann.joerg.blockchainWFMS.testing;

import java.util.Set;
import java.util.UUID;

import ca.evermann.joerg.blockchainWFMS.PetriNet.PetriNet;
import ca.evermann.joerg.blockchainWFMS.PetriNet.Transition;
import ca.evermann.joerg.blockchainWFMS.chain.Transaction;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainUtils;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;
import ca.evermann.joerg.blockchainWFMS.workflow.PetriNetInstance;
import ca.evermann.joerg.blockchainWFMS.workflow.transactions.InstanceStateTransaction;

public class TestRunner implements Runnable {

	P2PNode myP2PNode;
	PetriNet pn;
	int txCount = 0;
	int testnum;
	int[] resultpool;
	
	public TestRunner(P2PNode node, PetriNet pn, int i, int[] resultpool) {
		this.myP2PNode = node;
		this.pn = pn;
		this.testnum = i;
		this.resultpool = resultpool;
	}

	@Override
	public void run() {
		UUID currentUUID = UUID.randomUUID();
//		System.out.println("[TestRunner] ["+testnum+"] with UUID "+currentUUID.toString());
		PetriNetInstance pni = new PetriNetInstance( ((WorkflowEngineTest)myP2PNode.workflowEngine).getPetriNet(pn.getName()), currentUUID);

		Transaction t = new InstanceStateTransaction(pni);
		t.setOriginator(myP2PNode.whoAmI());
		myP2PNode.signTransaction(t);
//		System.out.println("[TestRunner] ["+testnum+"] Tx "+txCount + " " + t.payload.toString());
		myP2PNode.addTransaction(t);
		txCount++;

		Set<Transition> tiSet;
		synchronized(myP2PNode.workflowEngine) {
			pni = ((WorkflowEngineTest)myP2PNode.workflowEngine).getPetriNetInstance(pn, currentUUID);
			while (pni == null) {
				try {
//					System.out.println("[TestRunner] ["+testnum+"] wait <--");
					myP2PNode.workflowEngine.wait();
//					System.out.println("[TestRunner] ["+testnum+"] wait -->");
				} catch (InterruptedException e) {}
				pni = ((WorkflowEngineTest)myP2PNode.workflowEngine).getPetriNetInstance(pn, currentUUID);
			}
			tiSet = pni.getEnabled();
		}
		while (tiSet != null && tiSet.size()>0) {
			Transition ti = (Transition)tiSet.toArray()[0];
			pni = (PetriNetInstance) BlockChainUtils.deepCopy(pni);
			pni.fire(ti);
			// prepare a blockchain transaction and pass to transaction service
			t = new InstanceStateTransaction(pni);
			t.setOriginator(myP2PNode.whoAmI());
			myP2PNode.signTransaction(t);
//			System.out.println("[TestRunner] ["+testnum+"] Tx "+txCount + " " + t.payload.toString());
			myP2PNode.addTransaction(t);
			txCount++;
			
			PetriNetInstance oldPNI = pni;
			synchronized(myP2PNode.workflowEngine) {
				pni = ((WorkflowEngineTest)myP2PNode.workflowEngine).getPetriNetInstance(pn, currentUUID);
				while(pni != null && !pni.deepEquals(oldPNI)) {
					try {
//						System.out.println("[TestRunner] ["+testnum+"] wait on workflowEngine <--");
						myP2PNode.workflowEngine.wait();
//						System.out.println("[TestRunner] ["+testnum+"] wait on workflowEngine -->");
					} catch (InterruptedException e) {}
					pni = ((WorkflowEngineTest)myP2PNode.workflowEngine).getPetriNetInstance(pn, currentUUID);
				}
			}
			if (pni != null) {
				tiSet = pni.getEnabled();

			} else {
				tiSet = null;
			}
		}
		resultpool[testnum] = txCount;
	}
}
