package ca.evermann.joerg.blockchainWFMS.testing;

import java.util.HashMap;
import java.util.UUID;

import ca.evermann.joerg.blockchainWFMS.PetriNet.ActivitySpec;
import ca.evermann.joerg.blockchainWFMS.PetriNet.PetriNet;
import ca.evermann.joerg.blockchainWFMS.PetriNet.Transition;
import ca.evermann.joerg.blockchainWFMS.chain.Block;
import ca.evermann.joerg.blockchainWFMS.chain.Transaction;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;
import ca.evermann.joerg.blockchainWFMS.workflow.ActivityInstance;
import ca.evermann.joerg.blockchainWFMS.workflow.PetriNetInstance;
import ca.evermann.joerg.blockchainWFMS.workflow.Worklist;

public class WorkflowEngineTest extends ca.evermann.joerg.blockchainWFMS.workflow.WorkflowEngine implements Runnable {

	/* 
	 * This is a workflow engine implementation without user interface. 
	 * 
	 * The attribute worklist and the method updateWorklist have been pulled in from
	 * the WorklistUI class. updateWorklist has been simplified, removing the 
	 * option to call external classes for execution.
	 */
	
	public Worklist	worklist = new Worklist();
	
	public WorkflowEngineTest(P2PNode p2pnode) {		
		this.p2pnode = p2pnode;
		this.runningInstances = new HashMap<UUID, PetriNetInstance>();
		this.knownPetriNets = new HashMap<String, PetriNet>();
	}
	
	/*
	 * This is called by the block service when a block is added to the main branch
	 */
	@Override
	protected void receiveBlock(Block b) {
		if (b != null) {
			synchronized(this) {
				// newly considered confirmed block 
				Transaction t = b.getTransaction();
				if (t instanceof ca.evermann.joerg.blockchainWFMS.workflow.transactions.ModelDefinitionTransaction) {
					PetriNet pn = (PetriNet)t.payload;
					if (!knownPetriNets.containsKey(pn.getName())) {
						knownPetriNets.put(pn.getName(), pn);
					}
				}
				if (t instanceof ca.evermann.joerg.blockchainWFMS.workflow.transactions.InstanceStateTransaction) {
					// System.out.println("Workflow engine received transaction " + t.toString());
					PetriNetInstance pni = (PetriNetInstance)t.payload;
					runningInstances.put(pni.getId(), pni);
					// System.out.println("Workflow engine updated instances");
					updateWorklist(pni);
					// System.out.println("Workflow engine updated UI");
				}
//				System.out.println("[WorkflowEngine] " + this.toString());
//				System.out.println("[WorkflowEngine] notifyAll");
				notifyAll();
			}
		}
	}
	
	void updateWorklist(PetriNetInstance pni) {
		synchronized (this) {
			worklist.removeCase(pni.getId().toString());
			if (pni.isDone()) {
				runningInstances.remove(pni.getId());
			}
			if (pni.isDeadlocked()) {
				runningInstances.remove(pni.getId());
			}
			for (Transition transition : pni.getEnabled()) {
				ActivitySpec activity = transition.getActivity();
				if (activity.getHost().equals(this.p2pnode.whoAmI().getHost()) && activity.getPort()==this.p2pnode.whoAmI().getPort()) {
					ActivityInstance actInstance = new ActivityInstance(pni, transition);
					worklist.put(actInstance);
				}
			}
		}
	}

}
