library(MASS)
data <- read.csv('simulated.data.283.csv')
# set up some variables
n <- nrow(data) # Number of observations
S.f <- cov(data) # Covariance matrix of data
c <- 0 # Counter for PPP
diff <- matrix(0) # Store differences in fit
# Move thinned MCMC samples into data frame for easier access
d <- as.data.frame(as.matrix(thinned, iters=TRUE, chains=TRUE))
# Loop over all retained MCMC samples
for (l in seq(start(thinned), end(thinned), thin(thinned))) {
  # Calculate the mean parameter values over all chains
  m <- apply(d[d$ITER==l,], 2, mean)
  # Matrix ephat.mat is the error variance matrix
  ephat.mat <- diag(m[3:14], nrow=12, ncol=12)
  # Matrix phi.mat is the latent covariance matrix
  phi.mat <- matrix(m[28:31], nrow=2, ncol=2, byrow=TRUE)
  # Matrix lambda.mat is the loading matrix
  lambda.mat <- matrix(c(m[15:20], rep(0,12), m[21:26]), nrow=12, ncol=2, byrow=FALSE)
  # Calculate predicted covariance matrix
  Sigma.pred <- lambda.mat %*% phi.mat %*% t(lambda.mat) + ephat.mat
  # The chi-square discrepancy based on current model and actual covariance
  f <- (n - 1) * (log(det(Sigma.pred)) + sum(diag(solve(Sigma.pred) %*% S.f )) - log(det(S.f)) - 12)
  # Simulate data set from current model
  sim.data <- mvrnorm(n=n, mu=rep(0,12), Sigma=Sigma.pred, empirical=FALSE)
  # Calculate simulated data covariance matrix
  S.pred <- cov(sim.data)
  # The chi-square discrepancy based on current model and predicted data
  f.pred <- (nrow(sim.data) - 1) * (log(det(Sigma.pred)) + sum(diag(solve(Sigma.pred) %*% S.pred)) - log(det(S.pred)) - 12)
  # Some output to see what is going on
  cat('Iteration', l, ': f.pred = ', f.pred, ' // f = ', f, ' \n')
  # Keep track of the differences in discrepancy function values
  diff[ (l - start(thinned))/thin(thinned) + 1] <- abs(f.pred-f)
  # Keep track of whether model fits better to actual than to predicted data
  if (f < f.pred) c <- c + 1
}
# Report 95% confidence interval on fit differences
quantile(diff, c(0.05, 0.95))
# Report the PPP
c/length(diff)
