xi <- rnorm(1000, 0, 1)

x1 <- 1.1*xi + rnorm(1000, 0, 0.1)
x2 <- xi + rnorm(1000, 0, 0.1)
x3 <- 0.9*xi + rnorm(1000, 0, 0.1)

eta <- 0.8*xi + rnorm(1000, 0, 0.1)

y1 <- 1.1*eta + rnorm(1000, 0, 0.1)
y2 <- eta + rnorm(1000, 0, 0.1)
y3 <- 0.8*eta + rnorm(1000, 0, 0.1)

cutoffs <- c(-200, -2.5, -1, 1, 2.5, 200)

x1c <- findInterval(x1, cutoffs)
x2c <- findInterval(x2, cutoffs)
x3c <- findInterval(x3, cutoffs)
y1c <- findInterval(y1, cutoffs)
y2c <- findInterval(y2, cutoffs)
y3c <- findInterval(y3, cutoffs)

y <- cbind(x1, x2, x3, y1, y2, y3)
z <- cbind(x1c, x2c, x3c, y1c, y2c, y3c)
N <- 1000
P <- 6

dump(c('N', 'P', 'cutoffs', 'z'), 'example7data.jags.txt')
dump(c('y'), 'example7inits1.jags.txt')

dput(aperm(z), 'example7data.openbugs.txt')
dput(aperm(y), 'example7inits1.openbugs.txt')

