package ca.evermann.joerg.blockchainWFMS.PetriNet;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ActivitySpec implements Serializable {

	private String		role;
	private	String		host;
	private	Integer		port;
	
	private Set<String>		inputs;
	private Set<String>		outputs;
	private List<String>	constraints;
	private String			execClass;
	private String			execMethod;
	@SuppressWarnings("rawtypes")
	private Map<String, Class> 	types;
	
	@SuppressWarnings("rawtypes")
	public ActivitySpec(String role, 
						String host, 
						Integer port, 
						Set<String> inputs, 
						Set<String> outputs, 
						Map<String, Class> types, 
						List<String> constraints, 
						String execClass, 
						String execMethod) {
		this.role = role;
		this.host = host;
		this.port = port;
		this.inputs = inputs;
		this.outputs = outputs;
		this.types = types;
		this.constraints = constraints;
		this.execClass = execClass;
		this.execMethod = execMethod;
	}
	
	@SuppressWarnings("rawtypes")
	ActivitySpec() {
		super();
		role = "";
		host = "";
		port = 0;
		execClass = "";
		execMethod = "";
		inputs = new TreeSet<String>();
		outputs = new TreeSet<String>();
		constraints = new ArrayList<String>();
		types = new TreeMap<String, Class>();
	}
	
	public String getExecClass() {
		return execClass;
	}
	public void setExecClass(String buffer) {
		this.execClass = buffer;
	}
	public String getExecMethod() {
		return execMethod;
	}
	public void setExecMethod(String buffer) {
		this.execMethod = buffer;
	}
	public String getRole() {
		return role;
	}
	public void setRole(String role) {
		this.role = role;
	}
	public String getHost() {
		return host;
	}
	public void setHost(String host) {
		this.host = host;
	}
	public Integer getPort() {
		return port;
	}
	public void setPort(Integer port) {
		this.port = port;
	}
	public Set<String> getInputs() {
		return inputs;
	}
	public void setInputs(Set<String> inputs) {
		this.inputs = inputs;
	}
	public Set<String> getOutputs() {
		return outputs;
	}
	public void setOutputs(Set<String> outputs) {
		this.outputs = outputs;
	}

	public List<String> getConstraints() {
		return constraints;
	}

	public void setConstraints(List<String> constraints) {
		this.constraints = constraints;
	}

	@SuppressWarnings("rawtypes")
	public Map<String, Class> getTypes() {
		return types;
	}

	@SuppressWarnings("rawtypes")
	public void setTypes(Map<String, Class> types) {
		this.types = types;
	}

	public void writeToFile(PrintWriter out) {
		out.println("\t\t\t<Host>"+host+"</Host>");
		out.println("\t\t\t<Port>"+port.toString()+"</Port>");
		out.println("\t\t\t<Role>"+role+"</Role>");
		if (inputs.size() > 0) {
			out.println("\t\t\t<Inputs>");
			for (String input : inputs) {
				out.println("\t\t\t\t<Input type=\""+types.get(input).getName()+"\">" + input + "</Input>");
			}
			out.println("\t\t\t</Inputs>");
		}
		if (outputs.size() > 0) {
			out.println("\t\t\t<Outputs>");
			for (String output : outputs) {
				out.println("\t\t\t\t<Output type=\""+types.get(output).getName()+"\">" + output + "</Output>");
			}
			out.println("\t\t\t</Outputs>");
		}
		if (constraints.size() > 0) {
			out.println("\t\t\t<Constraints>");
			for (String constraint : constraints) {
				out.println("\t\t\t\t<Constraint>" + constraint + "</Constraint>");
			}
			out.println("\t\t\t</Constraints>");
		}
		if (execClass.length() != 0 && execMethod.length() != 0) {
			out.println("\t\t\t<Execute>");
			out.println("\t\t\t\t<ExecClass>" + execClass + "</ExecClass>");
			out.println("\t\t\t\t<ExecMethod>" + execMethod + "</ExecMethod>");
			out.println("\t\t\t</Execute>");
		}
	}

	
}
