package ca.evermann.joerg.blockchainWFMS.PetriNet;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PetriNetXMLHandler extends DefaultHandler {
	
	public class PetriNetXMLException extends SAXException {
		public PetriNetXMLException(String msg) {
			super(msg);
		}
	}

	private enum State {
		NewPlace, PostPreset,
	}

	private State		state;
	private PetriNet	pn;
	private String		buffer;
	private String		label;
	private Transition	transition;
	private Set<Place>	pset;

	/** Creates a new instance of SAXConfigHandler */
	public PetriNetXMLHandler(PetriNet pn) {
		pn.init();
		this.pn = pn;
		buffer = new String();
	}

	public void characters(char[] values, int start, int length) {
	    // Received some characters, add to buffer
		buffer = buffer.concat(String.copyValueOf(values, start, length));
	}

	public void endElement(String nameSpaceURI, String localName, String qName) throws PetriNetXMLException {
	
		if (qName.equals("Preset")) {
			pn.addTransition(transition, pset.toArray(new Place[0]), new Place[0]);
		}
		if (qName.equals("Postset")) {
			pn.addTransition(transition, new Place[0], pset.toArray(new Place[0]));
		}
		if (qName.equals("Transition")) {
			pn.addTransition(transition,  new Place[0], new Place[0]);
		}
		if (qName.equals("Input")) {
			transition.getActivity().getInputs().add(buffer);
			try {
				transition.getActivity().getTypes().put(buffer, Class.forName(label));
			} catch (ClassNotFoundException e) {
				throw new PetriNetXMLException("Class "+label+" for input "+buffer+" does not exist");
			}
		}
		if (qName.equals("Output")) {
			transition.getActivity().getOutputs().add(buffer);
			try {
				transition.getActivity().getTypes().put(buffer, Class.forName(label));
			} catch (ClassNotFoundException e) {
				throw new PetriNetXMLException("Class "+label+" for output "+buffer+" does not exist");
			}
		}
		if (qName.equals("Constraint")) {
			transition.getActivity().getConstraints().add(buffer);
		}
		if (qName.equals("Host")) {
			transition.getActivity().setHost(buffer);			
		}
		if (qName.equals("ExecClass")) {
			transition.getActivity().setExecClass(buffer);
		}
		if (qName.equals("ExecMethod")) {
			transition.getActivity().setExecMethod(buffer);
		}
		if (qName.equals("Port")) {
			try {
				transition.getActivity().setPort(Integer.valueOf(buffer));
			} catch (NumberFormatException e) {
				throw new PetriNetXMLException("Port address "+buffer+" is invalid");
			}
		}
		if (qName.equals("Role")) {
			transition.getActivity().setRole(buffer);			
		}
		buffer = new String();
	}

	public void startElement(String str, String str1, String str2, org.xml.sax.Attributes attributes) throws PetriNetXMLException {
		if (str2 == "WorkflowSpecification") {
			if (attributes.getValue("name") == null) {
				throw new PetriNetXMLException("Missing workflow name");
			}
			pn.setName(attributes.getValue("name"));
		}
		if (str2 == "Places") state = State.NewPlace;
		if (str2 == "Preset" || str2 == "Postset") {
			if (attributes.getValue("transition") == null) {
				throw new PetriNetXMLException("No transition declared for "+str2);
			}
			transition = pn.getTransition(attributes.getValue("transition"));
			if (transition == null) {
				throw new PetriNetXMLException("Transition for "+str2+" does not exist");
			}
			pset = new HashSet<Place>();
			state = State.PostPreset;
		}
		if (str2 == "Transition") {
			transition = new Transition(attributes.getValue("name"));
			transition.setActivity(new ActivitySpec());
		}
		if (str2 == "Place" && state == State.NewPlace) {
			pn.getPlaces().add(new Place(UUID.fromString(attributes.getValue("id"))));
		}
		if (str2 == "Place" && state == State.PostPreset) {
			Place target = pn.getPlace(UUID.fromString(attributes.getValue("id")));
			if (target != null) {
				pset.add(target);
			} else {
				throw new PetriNetXMLException("Place "+attributes.getValue("id")+" in preset does not exist");
			}			
		}

		if (str2 == "Source") {
			Place src = pn.getPlace(UUID.fromString(attributes.getValue("id")));
			if (src != null) {
				pn.setSource(src);
			} else {
				throw new PetriNetXMLException("Source place "+attributes.getValue("id")+" does not exist");
			}
		}
		if (str2 == "Sink") {
			Place snk = pn.getPlace(UUID.fromString(attributes.getValue("id")));
			if (snk != null) {
				pn.setSink(snk);
			} else {
				throw new PetriNetXMLException("Sink place "+attributes.getValue("id")+" does not exist");
			}
		}
		
		if (str2 == "Input" || str2 == "Output") {
			label = attributes.getValue("type");
			if (label == null) {
				throw new PetriNetXMLException("Type not specified for input");
			}
		}
		
		buffer = new String();
	}

}
