package ca.evermann.joerg.blockchainWFMS.main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BlockChainUtils {

	public static Serializable deepCopy(Serializable object) {
		if (object == null)
			return null;
		try {
			ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
			ObjectOutputStream outputStrm = new ObjectOutputStream(outputStream);
			outputStrm.writeObject(object);
			ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
			ObjectInputStream objInputStream = new ObjectInputStream(inputStream);
			return (Serializable)objInputStream.readObject();
		}
		catch (IOException | ClassNotFoundException e) {
			System.err.println("DeepCopy error");
			return null;
		}
	}

	public static String right(String s, int n) {
		if (n < 1) return "";
		return s.substring(s.length()-Math.min(n, s.length()), s.length());
	}
}
