package ca.evermann.joerg.blockchainWFMS.main;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import ca.evermann.joerg.blockchainWFMS.chain.TestTransaction;
import ca.evermann.joerg.blockchainWFMS.chain.Transaction;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.TestMessage;

public class BlockChainWFMSUI extends JFrame {
	
	public JTextArea logTxt;
	
	public BlockChainWFMSUI(P2PNode node, JTextArea logTxt) {
		this.logTxt = logTxt;
		
		this.setTitle("BlockchainWFMS host " + node.whoAmI().getHost() + " on port " + node.whoAmI().getPort().toString());
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		this.setSize(600, 400);
		this.setMinimumSize(new Dimension(600, 400));
		
		Image icon;
		try {
			URL u = BlockChainWFMSUI.class.getResource("icons8-arbeitsablauf-80.png");
			icon = ImageIO.read(u);
			this.setIconImage(icon);
		} catch (IOException e) {
			// proceed without custom icon
		}
		
		JButton msgButton = new JButton("Test Message");
		msgButton.addActionListener((ActionEvent event) -> {
			node.sendMessage(new TestMessage(node.whoAmI().getPort()));
		});
		
		JButton exitButton = new JButton("Exit");
		exitButton.addActionListener((ActionEvent event) -> {
			node.Shutdown();
			System.exit(0);
		});
		
		JButton txButton = new JButton("Test Transaction");
		txButton.addActionListener((ActionEvent event) -> {
			Transaction t = new TestTransaction(new String("Hello Transaction"));
			t.setOriginator(node.whoAmI());
			node.signTransaction(t);
			node.transactionService.add(t, node.whoAmI());
		});
		
		JScrollPane txtScroll = new JScrollPane(this.logTxt);
		txtScroll.setMinimumSize(new Dimension(500, 300));
		
	    Container pane = getContentPane();
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = GridBagConstraints.WEST;
        gc.fill = GridBagConstraints.BOTH;
        pane.setLayout(gl);
        
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1;
        gc.weighty = 0;
        pane.add(exitButton, gc);
        gc.gridx = 1;
        pane.add(msgButton, gc);
        gc.gridx = 2;
        pane.add(txButton, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weighty = 2;
        gc.gridwidth = 3;
        pane.add(txtScroll, gc);
	}

}
