package ca.evermann.joerg.blockchainWFMS.main;

import java.awt.EventQueue;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.Set;

import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

import ca.evermann.joerg.blockchainWFMS.CA.CryptoUtils;
import ca.evermann.joerg.blockchainWFMS.CA.PeerCertificate;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;

public class BlockchainWFMS {

	public static JTextArea logTxt;
	
	public static void setupLogText() {
		logTxt = new JTextArea(50, 130);
		logTxt.setEditable(false);
		logTxt.setAutoscrolls(true);
		DefaultCaret caret = (DefaultCaret)logTxt.getCaret();
		caret.setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
		PrintStream out = new PrintStream(new JTextAreaOutputStream(logTxt));
		System.setOut(out);
		System.setErr(out);
	}
	
	
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		int listeningPort = 0;
		
		setupLogText();
		
		if (args.length < 2) {
			System.err.println("Must provide at least your hostname and a listening port, and optionally a list of known hosts");
			System.exit(-1);
		}

		String myHostname = args[0];
		try {
			listeningPort = Integer.parseInt(args[1]);
		} catch (NumberFormatException e) {
			System.err.println("First argument must be integer");
			System.exit(-1);
		}
		PublicKey CAPublicKey = CryptoUtils.readPublicKey("CAPublic.key");
		if (CAPublicKey == null) {
			System.err.println("Unable to read CA public key");
			System.exit(-1);
		}
		PeerCertificate myCertificate = new PeerCertificate(myHostname, listeningPort);
		if (!myCertificate.verifySignature()) {
			System.err.println("Unable to verify my certificate");
			System.exit(-1);
		}
		PrivateKey mySigningKey = CryptoUtils.readPrivateKey(myHostname+"."+Integer.toString(listeningPort)+".PeerPrivate.key");
		if (mySigningKey == null) {
			System.err.println("Unable to read my signing key");
			System.exit(-1);
		}
	
		Set<PeerCertificate> knownPeers = new HashSet<PeerCertificate>();
		ObjectInputStream o = null;
		try {
			o = new ObjectInputStream(new FileInputStream(myCertificate.getHost()+"."+myCertificate.getPort()+".knownPeers.js"));
			knownPeers = (Set<PeerCertificate>) o.readObject();
			o.close();
		} catch (IOException e) {
			System.err.println("Error while loading known hosts");
		} catch (ClassNotFoundException e) {
			System.err.println("Class not found while loading known hosts");
		}
		
		Set<String> additionalHosts = new HashSet<String>();
		for (int i=2; i<args.length; i++) {
			additionalHosts.add(args[i]);
		}
		
		P2PNode	myP2PNode = new P2PNode(knownPeers, myCertificate, mySigningKey, additionalHosts);
	
		EventQueue.invokeLater(() -> {
			BlockChainWFMSUI ex = new BlockChainWFMSUI(myP2PNode, logTxt);
			ex.setVisible(true); 
		});
		
	}

}
