package ca.evermann.joerg.blockchainWFMS.p2p;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainSendMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockRequestMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockSendMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainRequestMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.PeersRequestMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.TransactionPoolRequestMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.Message;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.PeersSendMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.TestMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.TransactionPoolSendMessage;
import ca.evermann.joerg.blockchainWFMS.p2p.messages.TransactionSendMessage;

public class InboundMsgHandler implements Runnable {

	private P2PNode node;

	public Boolean stop;

	public InboundMsgHandler(P2PNode node) {
		this.node = node;
		this.stop = false;
	}
	
	@Override
	public void run() {
		while (!stop) {
			for (BlockingQueue<Message> q : node.getInboundQueues()) {
				Message msg;
				try {
					msg = q.poll(500, TimeUnit.MILLISECONDS);
				} catch (InterruptedException e) {
					System.err.println("Interrupted inbound message take");
					break;
				}
				if (msg != null) {
					if (msg.verifySender()) {
						if (!msg.getSender().equals(node.myCertificate)) {
							if (msg.verifyContent()) {
								System.err.print("Received : ");
								switch (msg.getClass().getName()) {
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.Message":
									System.err.println("Message (abstract and should be subclassed)");
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.TestMessage":
									TestMessage test = (TestMessage) msg;
									System.err.println(test.toString());
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.PeersSendMessage":
									PeersSendMessage addPeersMsg = (PeersSendMessage) msg;
									System.err.println(addPeersMsg.toString());
									node.addPeers(addPeersMsg.getHosts());
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.PeersRequestMessage":
									PeersRequestMessage getPeersMsg = (PeersRequestMessage) msg;
									System.err.println(getPeersMsg.toString());
									node.sendKnownPeersTo(getPeersMsg.getSender());
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.TransactionPoolRequestMessage":
									TransactionPoolRequestMessage getTransactionsMsg = (TransactionPoolRequestMessage) msg;
									System.err.println(getTransactionsMsg.toString());
									node.sendTransactionPoolTo(getTransactionsMsg.getSender());
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.TransactionPoolSendMessage":
									TransactionPoolSendMessage txPoolMsg = (TransactionPoolSendMessage) msg;
									System.err.println(txPoolMsg.toString());
									node.receiveTransactionPool(txPoolMsg);
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.TransactionSendMessage":
									TransactionSendMessage tMsg = (TransactionSendMessage) msg;
									System.err.println(tMsg.toString());
									node.receiveTransaction(tMsg);
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainRequestMessage":
									BlockchainRequestMessage getBlockchainMsg = (BlockchainRequestMessage) msg;
									System.err.println(getBlockchainMsg.toString());
									node.sendBlockchainTo(getBlockchainMsg.getSender(), getBlockchainMsg.fromHashes());
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockchainSendMessage":
									BlockchainSendMessage bcMsg = (BlockchainSendMessage) msg;
									System.err.println(bcMsg.toString());
									node.receiveBlockChain(bcMsg);
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockRequestMessage":
									BlockRequestMessage getBlockMsg = (BlockRequestMessage) msg;
									System.err.println(getBlockMsg.toString());
									node.sendBlockTo(getBlockMsg.getSender(), getBlockMsg.getBlockHash());
									break;
								case "ca.evermann.joerg.blockchainWFMS.p2p.messages.BlockSendMessage":
									BlockSendMessage bMsg = (BlockSendMessage) msg;
									System.err.println(bMsg.toString());
									node.receiveBlock(bMsg);
									break;
								default:
									System.err.println("Unknown message received");
									break;
								}
							} else {
								System.err.println("Message with unverified content received");
							}
						} else {
							System.err.println("Message to self received, ignoring");
						}
					} else {
						System.err.println("Message received from unverified sender");
					}
				}
			}
		}
	}

}
