package ca.evermann.joerg.blockchainWFMS.p2p;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.BlockingQueue;

import ca.evermann.joerg.blockchainWFMS.p2p.messages.Message;

public class OutboundQueueHandler implements Runnable {

	public Boolean stop;
	private BlockingQueue<Message> outboundQueue;
	private ObjectOutputStream outStream;
	
	public OutboundQueueHandler(BlockingQueue<Message> outboundQueue, ObjectOutputStream outStream) {
		this.outboundQueue = outboundQueue;
		this.outStream = outStream;
		this.stop = false;
	}

	@Override
	public void run() {
		while (!stop) {
			Message outmsg;
			try {
				outmsg = outboundQueue.take();
			} catch (InterruptedException e1) {
				System.err.println("Interrupted outbound queue take in thread " + Thread.currentThread().getName());
				continue;
			}
			if (outmsg != null) {
				try {
					outStream.writeObject(outmsg);
					outStream.flush();
				} catch (IOException e) {
					continue;
				}
			}
		}
	}

}
