package ca.evermann.joerg.blockchainWFMS.workflow;

import java.util.Set;
import java.util.Vector;

import ca.evermann.joerg.blockchainWFMS.PetriNet.PetriNet;
import ca.evermann.joerg.blockchainWFMS.chain.Transaction;
import ca.evermann.joerg.blockchainWFMS.workflow.transactions.InitCaseTransaction;

public class ValidatingWorkflowState extends WorkflowState {

	ValidatingWorkflowState(WorkflowEngine engine) {
		super(engine, 0);
	}

	/*
	 * Validates the transaction t against the workflow state either at the head
	 * of the block chain, or, if pendingTx is not null, validates against the workflow
	 * state at the head of the chain and including the pending transactions
	 */
	boolean validateTransaction(Transaction t, Set<Transaction> pendingTx) {
		if (t != null) {
			if (t.payload == null) 
				return false;
			
			Vector<Transaction> orderedPendingTx = new Vector<Transaction>();
			boolean valid = false;
			
			switch (t.getClass().getName()) {
			case "ca.evermann.joerg.blockchainWFMS.workflow.transactions.FireTransitionTransaction":
				ActivityInstance activityInstance = (ActivityInstance)t.payload;
				PetriNetInstance pni = getPetriNetInstance(activityInstance);
				if (pni == null) {
					return false;
				}
				/*
				 * Forward the state to take into account pending transactions, if any
				 */
				if (pendingTx != null) {
					for (Transaction pending : pendingTx) {
						doTransaction(pending);
						orderedPendingTx.add(0, pending);
					}
				}
				valid = pni.getEnabled().contains(activityInstance.getTransition());
				valid = valid & activityInstance.checkConstraints();
				/*
				 * Backup the state by undoing the pending transactions in the order in which they were done
				 */
				if (pendingTx != null) {
					for (Transaction pending : orderedPendingTx) {
						undoTransaction(pending);
					}
				}
				return valid;
			case "ca.evermann.joerg.blockchainWFMS.workflow.transactions.InitCaseTransaction":
				InitCaseTransaction.NetNameAndCaseId netNameAndCaseId = (InitCaseTransaction.NetNameAndCaseId) t.payload;
				PetriNet pn = this.knownPetriNets.get(netNameAndCaseId.getName());
				if (pn == null) {
					return false;
				}
				return true;
			case "ca.evermann.joerg.blockchainWFMS.workflow.transactions.ModelUpdateTransaction":
				PetriNet	petriNet = (PetriNet) t.payload;
				/*
				 * Forward the state to take into account pending transactions, if any
				 */
				if (pendingTx != null) {
					for (Transaction pending : pendingTx) {
						doTransaction(pending);
						orderedPendingTx.add(0, pending);
					}
				}
				valid = !this.knownPetriNets.containsKey(petriNet.getName());
				/*
				 * Backup the state by undoing the pending transactions in the order in which they were done
				 */
				if (pendingTx != null) {
					for (Transaction pending : orderedPendingTx) {
						undoTransaction(pending);
					}
				}				
				return valid;
			default:
				return true;
			}
		}
		return false;
	}
	
	@Override
	protected void doTransaction(Transaction t) {
		/* 
		 * We do not validate here, because validation is called prior to doing the block in all cases where this is called
		 * (Less safe to rely on that, but better performance)
		 */
//		if (validateTransaction(t, null)) {
			super.doTransaction(t);
//		}
	}

}
