package ca.evermann.joerg.blockchainWFMS.workflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Set;

import ca.evermann.joerg.blockchainWFMS.chain.Block;
import ca.evermann.joerg.blockchainWFMS.chain.Transaction;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainWFMSConfig;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;

public class WorkflowEngine {

	P2PNode						p2pnode;
	ValidatingWorkflowState		chainHeadState;
	VisibleWorkflowState		visibleState;

	public WorkflowEngine(P2PNode p2pnode) {
		this.p2pnode = p2pnode;

		chainHeadState = new ValidatingWorkflowState(this);
		visibleState = new VisibleWorkflowState(this, BlockChainWFMSConfig.minConfirmDepth);
		loadWorkflowStates();
	}

	public void enableWorkflowUIs() {
		visibleState.enableWorkflowUI();
	}

	public void disableWorkflowUIs() {
		visibleState.disableWorkflowUI();
	}

	private void readStates(String fname) {
		ObjectInputStream o;
		try {
			o = new ObjectInputStream(new FileInputStream(fname));
			chainHeadState.readState(o);
			visibleState.readState(o);
			o.close();
		} catch (IOException e) {
			System.err.println("Error while reading workflow state");
		}
	}
	public void writeStates(String fname) {
		ObjectOutputStream o = null;
		try {
			o = new ObjectOutputStream(new FileOutputStream(fname));
			chainHeadState.persistState(o);
			visibleState.persistState(o);
			o.close();
			System.out.println(this.toString());
		} catch (IOException e) {
			System.err.println("Error while writing workflow state");
		}
    }
	public void saveWorkflowStates() {
		writeStates(p2pnode.whoAmI().getHost()+"."+p2pnode.whoAmI().getPort()+".savedState.js");
    }    
    public void recoverWorkflowStates() {
		readStates(p2pnode.whoAmI().getHost()+"."+p2pnode.whoAmI().getPort()+".savedState.js");
		File f = new File(p2pnode.whoAmI().getHost()+"."+p2pnode.whoAmI().getPort()+".savedState.js");
		f.delete();
    }
	public void persistWorkflowStates() {
		writeStates(p2pnode.whoAmI().getHost()+"."+p2pnode.whoAmI().getPort()+".workflowState.js");
    }    
    public void loadWorkflowStates() {
		readStates(p2pnode.whoAmI().getHost()+"."+p2pnode.whoAmI().getPort()+".workflowState.js");
    }

    public void doBlock(Block b) {
    	System.out.println("True state do block called on "+Base64.getEncoder().encodeToString(b.getHash()));
    	chainHeadState.doBlock(b);
    	System.out.println("Visi state do block called on "+Base64.getEncoder().encodeToString(b.getHash()));
    	visibleState.doBlock(b);
    	persistWorkflowStates();
    }

    public void undoBlock(Block b) {
    	System.out.println("True state undo block called on "+Base64.getEncoder().encodeToString(b.getHash()));
    	chainHeadState.undoBlock(b);
    	System.out.println("Visi state undo block called on "+Base64.getEncoder().encodeToString(b.getHash()));
    	visibleState.undoBlock(b);
    	persistWorkflowStates();
    }

	public boolean validateTransaction(Transaction t, Set<Transaction> pendingTx) {
		return chainHeadState.validateTransaction(t, pendingTx);
	}
	
	public void addPendingTransaction(Transaction transaction) {
		this.visibleState.addPendingTransaction(transaction);
	}

	@Override
	public String toString() {
		return "True state:\n" + chainHeadState.toString() + "Visi state:\n" + visibleState.toString();
	}
}
