package ca.evermann.joerg.blockchainWFMS.workflow.transactions;


import java.io.Serializable;
import java.util.UUID;

import ca.evermann.joerg.blockchainWFMS.chain.Transaction;

public class InitCaseTransaction extends Transaction {

	public static class NetNameAndCaseId implements Serializable {
		private String netName;
		private UUID caseId;
		
		public NetNameAndCaseId(String netName, UUID caseId) {
			this.netName = netName;
			this.caseId = caseId;
		}
		
		@Override
		public String toString() {
			return "NetName " + this.netName + " CaseId " + this.caseId;
		}

		public String getName() {
			return netName;
		}
		
		public UUID getCaseId() {
			return caseId;
		}
	}
	/*
	 * Call this with an instance of NetNameAndCaseId
	 */
	public InitCaseTransaction(NetNameAndCaseId nameAndCaseId) {
		super(nameAndCaseId);
	}
	
}
