package ca.evermann.joerg.blockchainWFMS.CA;

import java.security.*;
import java.util.Base64;

public class CertificateAuthority {
	
	public static void generatePeerInfo(String hostname, Integer port) {
		PrivateKey CAPrivKey = CryptoUtils.readPrivateKey("CAPrivate.key");
		
		if (CAPrivKey != null) {
			SecureRandom secrnd = null;
			try {
				secrnd = SecureRandom.getInstance("SHA1PRNG");
			} catch (NoSuchAlgorithmException e1) {
				System.err.println("Could not initialize PRNG");
				return;
			}
			secrnd.setSeed(12345);

			KeyPairGenerator kpg = null;
			KeyPair keypair = null;
			try {
				kpg = KeyPairGenerator.getInstance("DSA");
				kpg.initialize(1024, secrnd);
				keypair = kpg.generateKeyPair();
				CryptoUtils.saveKey(keypair.getPrivate(), hostname+"."+port.toString()+".PeerPrivate.key");
				CryptoUtils.saveKey(keypair.getPublic(), hostname+"."+port.toString()+".PeerPublic.key");
				
				Signature sig;
				String content;
				try {
					sig = Signature.getInstance("SHA1withDSA");
					sig.initSign(CAPrivKey);
					content = hostname + port.toString() + new String(Base64.getEncoder().encodeToString(keypair.getPublic().getEncoded()));
					sig.update(content.getBytes());
					byte[] sigbytes = sig.sign(); 
					CryptoUtils.saveSignature(sigbytes, hostname+"."+port.toString()+".PeerPublic.sig");
					PeerCertificate pc = new PeerCertificate(hostname, port);
					if (pc.verifySignature()) {
						System.out.println("Generated and verified");
					} else {
						System.err.println("Could not verify signature");
					}
				} catch (NoSuchAlgorithmException e) {
					System.err.println("No such signature algorithm");
				} catch (InvalidKeyException e) {
					System.err.println("Invalid key");
				} catch (SignatureException e) {
					System.err.println("Signature exception");
				}
				
			} catch (NoSuchAlgorithmException e) {
				System.err.println("No such key pair generator algorithm");
				return;
			}	
		}
	}
	
	public static void initCA() {
		SecureRandom secrnd = null;
		try {
			secrnd = SecureRandom.getInstance("SHA1PRNG");
		} catch (NoSuchAlgorithmException e1) {
			System.err.println("Could not initialize PRNG");
			return;
		}
		secrnd.setSeed(12345);

		KeyPairGenerator kpg;
		KeyPair keypair = null;
		try {
			kpg = KeyPairGenerator.getInstance("DSA");
			kpg.initialize(1024, secrnd);
			keypair = kpg.generateKeyPair();
			CryptoUtils.saveKey(keypair.getPrivate(), "CAPrivate.key");
			CryptoUtils.saveKey(keypair.getPublic(), CryptoUtils.CAPublicKeyFileName);
		} catch (NoSuchAlgorithmException e) {
			System.err.println("No such key pair generator algorithm");
		}
				
	}
	
	public static void main(String[] args) {
		if (args.length > 0) {
			if (args[0].equals("initCA")) {
				initCA();
				System.exit(0);
			}
			if (args[0].equals("generatePeerInfo")) {
				if (args.length > 2) {
					try {
						generatePeerInfo(args[1], Integer.valueOf(args[2]));
						System.exit(0);
					} catch (NumberFormatException e) {
						System.err.println("Could not parse port information");
						System.exit(-1);
					}
				} else {
					System.err.println("Failed to specify hostname and/or port");
					System.exit(-1);
				}
			}
			System.err.println("Unrecognized option");
			System.exit(-1);
		} else {
			System.err.println("Must use either initCA or generatePeerInfo options");
			System.exit(-1);
		}

	}

}
