package ca.evermann.joerg.blockchainWFMS.CA;

import java.io.*;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class CryptoUtils {

	protected static final String CAPublicKeyFileName = "CAPublic.key";
	
	public static PublicKey getCAPublicKey() {
		return CryptoUtils.readPublicKey(CAPublicKeyFileName);
	}
	
	public static byte[] hashObject(Serializable obj) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos;
        if (obj==null) {
        	return null;
        }
		try {
			oos = new ObjectOutputStream( baos );
	        oos.writeObject(obj);
	        oos.close();
		} catch (IOException e) {
			System.err.println("IO Error when hashing");
			return null;
		}
        byte[] content = baos.toByteArray();
        MessageDigest md;
        try {
        	md = MessageDigest.getInstance("SHA-256");
        } catch (NoSuchAlgorithmException e) {
        	System.err.println("No such algorithm when hashing");
        	return null;
        }
        return md.digest(content);
	}
	
	public static void saveKey(Key theKey, String theFile) {
		String base64 = Base64.getEncoder().encodeToString(theKey.getEncoded());
		try {
			PrintWriter writer;
			writer = new PrintWriter(theFile);
			writer.print(base64);
			writer.close();
		} catch (FileNotFoundException e) {
			System.err.println("Cannot write key file");
		}
	}
	
	public static PublicKey readPublicKey(String theFile) {
		BufferedReader reader;
		try {
			reader = new BufferedReader(new FileReader(theFile));
			String content = reader.readLine();
			reader.close();
			KeyFactory kf = KeyFactory.getInstance("DSA");
			return kf.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(content)));
		} catch (FileNotFoundException e) {
			System.err.println("File not found when reading key");
		} catch (IOException e) {
			System.err.println("IO error when reading key");
		} catch (NoSuchAlgorithmException e) {
			System.err.println("No such algorithm when reading key");
		} catch (InvalidKeySpecException e) {
			System.err.println("Invalid key spec when reading key");
		}
		return null;
	}
	
	public static PrivateKey readPrivateKey(String theFile) {
		BufferedReader reader;
		try {
			reader = new BufferedReader(new FileReader(theFile));
			String content = reader.readLine();
			reader.close();
			KeyFactory kf = KeyFactory.getInstance("DSA");
			return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(content)));
		} catch (FileNotFoundException e) {
			System.err.println("File not found when reading key");
		} catch (IOException e) {
			System.err.println("IO error when reading key");
		} catch (NoSuchAlgorithmException e) {
			System.err.println("No such algorithm when reading key");
		} catch (InvalidKeySpecException e) {
			System.err.println("Invalid key spec when reading key");
		}
		return null;
	}
	
	public static void saveSignature(byte[] theSig, String theFile) {
		try {
			PrintWriter writer;
			writer = new PrintWriter(theFile);
			writer.print(Base64.getEncoder().encodeToString(theSig));
			writer.close();
		} catch (FileNotFoundException e) {
			System.err.println("Cannot write signature file");
		}
	}
	
	public static byte[] readSignature(String theFile) {
		BufferedReader reader;
		try {
			reader = new BufferedReader(new FileReader(theFile));
			String content = reader.readLine();
			reader.close();
			return Base64.getDecoder().decode(content);
		} catch (FileNotFoundException e) {
			System.err.println("File not found when reading key");
		} catch (IOException e) {
			System.err.println("IO error when reading key");
		}
		return null;
	}

	public static boolean verifySignature(String content, byte[] signature, PublicKey key) {
		Signature sig;
		try {
			sig = Signature.getInstance("SHA1withDSA");
			sig.initVerify(key);
			sig.update(content.getBytes());
			return sig.verify(signature);
		} catch (NoSuchAlgorithmException e) {
			System.err.println("No such algorithm when verifying");
			return false;
		} catch (InvalidKeyException e) {
			System.err.println("Invalid key when verifying");
			return false;
		} catch (SignatureException e) {
			System.err.println("Signature exception when verifying");
			return false;
		}
	}
	
	public static byte[] signObject(Serializable obj, PrivateKey key) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos;
        if (obj==null || key==null) {
        	return null;
        }
		try {
			oos = new ObjectOutputStream( baos );
	        oos.writeObject(obj);
	        oos.close();
	        String content = Base64.getEncoder().encodeToString(baos.toByteArray());
			try {
				Signature sig = Signature.getInstance("SHA1withDSA");
				sig.initSign(key);
				sig.update(content.getBytes());
				byte[] sigbytes = sig.sign();
				return sigbytes;
			} catch (NoSuchAlgorithmException e) {
				System.err.println("No such signature algorithm");
			} catch (InvalidKeyException e) {
				System.err.println("Invalid key");
			} catch (SignatureException e) {
				System.err.println("Signature exception");
			}
			return null;
		} catch (IOException e) {
			System.err.println("IO Error in signObject");
			return null;
		}
	}

	public static boolean verifyObjectSignature(Serializable obj, byte[] signature, PublicKey key) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos;
        if (obj==null || key==null || signature==null) {
        	return false;
        }
		try {
			oos = new ObjectOutputStream( baos );
	        oos.writeObject(obj);
	        oos.close();
	        String content = Base64.getEncoder().encodeToString(baos.toByteArray());
			try {
				Signature sig = Signature.getInstance("SHA1withDSA");
				sig.initVerify(key);
				sig.update(content.getBytes());
				return sig.verify(signature);
			} catch (NoSuchAlgorithmException e) {
				System.err.println("No such signature algorithm");
			} catch (InvalidKeyException e) {
				System.err.println("Invalid key");
			} catch (SignatureException e) {
				System.err.println("Signature exception");
			}
			return false;
		} catch (IOException e) {
			System.err.println("IO Error in signObject");
			return false;
		}
	}

	
}
