package ca.evermann.joerg.blockchainWFMS.CA;

import java.io.Serializable;
import java.security.PublicKey;
import java.util.Base64;

public class PeerCertificate implements Serializable {
	private String host;
	private Integer port;
	private PublicKey key;
	private byte[] sig;
	
	public PeerCertificate(String host, Integer port) {
		this.host = host;
		this.port = port;
		this.key = CryptoUtils.readPublicKey(host+"."+port.toString()+".PeerPublic.key");
		this.sig = CryptoUtils.readSignature(host+"."+port.toString()+".PeerPublic.sig");
	}
	
	public boolean verifySignature() {	
		if (host != null && key != null && sig != null) {
			return CryptoUtils.verifySignature(this.host+this.port.toString()+Base64.getEncoder().encodeToString(this.key.getEncoded()), this.sig, CryptoUtils.getCAPublicKey());
		} else {
			return false;
		}
	}
	
	public String getHost() {
		return host;
	}
	public Integer getPort() {
		return port;
	}
	public PublicKey getKey() {
		return key;
	}
	public byte[] getSig() {
		return sig;
	}
	
	@Override
	public boolean equals(Object other) {
		if (other instanceof PeerCertificate) {
			return java.util.Arrays.hashCode(sig) == java.util.Arrays.hashCode( ((PeerCertificate)other).sig);
		} else {
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return java.util.Arrays.hashCode(sig);
	}
	
	@Override
	public String toString() {
		String s = new String(host);
		s = s.concat(":").concat(Integer.toString(port));
		return s;
	}
}

