package ca.evermann.joerg.blockchainWFMS.PetriNet;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.UUID;

public class Place implements Serializable, Comparable<Place> {

	private UUID placeID;
	
	public Place() {
		placeID = UUID.randomUUID();
	}

	public UUID getId() {
		return placeID;
	}
	
	/* we need this when reading from XML */
	Place(UUID theId) {
		placeID = theId;
	}
	
	@Override
	public String toString() {
		return new String("Place "+this.placeID);
	}
	
	@Override
	public int hashCode() {
		return placeID.hashCode();
	}
	
	@Override
	public boolean equals(Object other) {
		if (other == null) return false;
		if (this == other) return true;
		if (getClass() != other.getClass()) return false;
		return this.hashCode() == other.hashCode();
	}
	
	@Override
	public int compareTo(Place other) {
		if (other == null) return -1;
		if (this == other) return 0;
		if (getClass() != other.getClass()) return -1;
		return this.placeID.compareTo(other.placeID);
	}

	public void writeToFile(PrintWriter out) {
		out.println("\t\t<Place id=\""+placeID.toString()+"\"/>");
	}
	
}
