package ca.evermann.joerg.blockchainWFMS.chain;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainWFMSConfig;
import ca.evermann.joerg.blockchainWFMS.p2p.P2PNode;

public class MiningService implements Runnable {

	private P2PNode p2pnode;
	private BlockService blockService;
	public	boolean	stop = false;
	public  boolean paused = false;
	
	public MiningService(P2PNode p2pnode) {
		this.blockService = p2pnode.blockService;
		this.p2pnode = p2pnode;
	}
	
	private void MineTXPool() {
		System.out.println("Start mining");
		
		/* Get previous block's hash */
		byte[] prevBlockHash = null;
		if (blockService.getMainBranchHead() != null)
			prevBlockHash = blockService.getMainBranchHead().getHash();
		
		/* Grab some transactions from the pool */
		List<Transaction> myTx = new ArrayList<Transaction>();
		for (Transaction t : p2pnode.transactionService.getTransactionPool()) {
			if (myTx.size() >= BlockChainWFMSConfig.maxTransactionsPerBlock) {
				break;
			} else {
				myTx.add(t);
			}
		}
		
		/* Try generating block with right difficulty */
		Random rndGen = new Random(System.currentTimeMillis());
		Block b = null;
		while (!stop && !paused) {
			int miningNonce = rndGen.nextInt();
			b = new Block(prevBlockHash, myTx, miningNonce);
			if (b.getLeadingZerosCount() >= BlockChainWFMSConfig.difficulty) {
				break;
			}
		}
		if (!stop && !paused) {
			System.out.println("Mined a block: \n" + b.toString());
			// handle like a new block
			blockService.receiveBlock(b, p2pnode.whoAmI());
		} else {
			System.out.println("Mining interrupted");
		}
	}

	@Override
	public void run() {
		/*
		 * TODO: For testing purposes, the miner does not mine empty blocks, and sleeps between mining attempts.
		 * This must be changed for production purposes, because we must mine continuously, even if the blocks are empty
		 * Otherwise, a malicious miner can use the time to re-mine bad blocks into the chain
		 * TODO: Must also change the block verification, because we test for empty blocks there as well.
		 */
		Random rndGen = new Random(System.currentTimeMillis());
		while (!stop) {
			try {
				int sleepymillis = 1000*(rndGen.nextInt(9)+1);
				Thread.sleep(sleepymillis);
			} catch (InterruptedException e) {
				System.err.println("Mining service woken from sleep");
			}

			long lastBlockTime = System.currentTimeMillis();
			if (this.blockService.getMainBranchHead() != null) {
				lastBlockTime = this.blockService.getMainBranchHead().getTimestamp();
			}
			int txPoolSize = this.p2pnode.transactionService.getTransactionPool().size();
			
			/* We mine if the transaction pool is not empty and we have either more than half the max number of tx per block or max wait time is up */
			if (txPoolSize > 0) {
				if ( (txPoolSize >= BlockChainWFMSConfig.maxTransactionsPerBlock/2 || 
						System.currentTimeMillis()-lastBlockTime > BlockChainWFMSConfig.maxMiningWaitMillis ) ) {
					if (!paused)
						MineTXPool();
				}
			}
		}
	}

}
