package ca.evermann.joerg.blockchainWFMS.chain;

import java.util.Set;
import java.util.Vector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class TreeNode<T> implements Serializable {
	
	private T			 		element;
	private Set<TreeNode<T>> 	branches;
	private TreeNode<T>			bough;
	private int					height;
	
	public TreeNode(TreeNode<T> bough, T newElement) {
		this.element = newElement;
		this.branches = new HashSet<TreeNode<T>>();
		this.bough = bough;
		if (this.bough != null) {
			this.bough.branches.add(this);
			this.height = bough.height + 1;
		} else {
			/* Created a root */
			this.height = 0;
		}
	}
	
	public T getElement() {
		return element;
	}
	
	public TreeNode<T> getBough() {
		return bough;
	}
	
	public Set<TreeNode<T>> getSiblings() {
		if (bough == null) return null;
		Set<TreeNode<T>> sibs = bough.getBranches();
		sibs.remove(this);
		return sibs;
	}
	
	public Set<TreeNode<T>> getBranches() {
		return branches;
	}
	
	public boolean isFinal() { 
		return (branches.size() == 0);
	}

	public boolean isFork() {
		return (branches.size() > 1);
	}
	
	public boolean isRoot() {
		return (height == 0);
	}
	
	public int getHeight() { 
		return height;
	}
	
	private List<TreeNode<T>> getAncestors_(List<TreeNode<T>> anc) {
		TreeNode<T> last = anc.get(anc.size()-1);
		if (last.bough != null) {
			anc.add(last.bough);
			return getAncestors_(anc);
		} else {
			return anc;
		}
	}
	
	public List<TreeNode<T>> getAncestors() {
		List<TreeNode<T>> anc = new Vector<TreeNode<T>>();
		if (bough != null) {
			anc.add(bough);
			return getAncestors_(anc);
		} else {
			return anc;
		}
	}
	
	public void getDescendants_(ArrayList<T> desc) {
		if (!isFinal()) {
			for (TreeNode<T> node : getBranches()) {
				desc.add(node.element);
				node.getDescendants_(desc);
			}
		}
	}
	
	public ArrayList<T> getDescendants() {
		ArrayList<T> desc = new ArrayList<T>();
		desc.add(this.element);
		getDescendants_(desc);
		return desc;
	}
	
	public TreeNode<T> commonAncestor(TreeNode<T> other) {
		List<TreeNode<T>> myAncestors = this.getAncestors();
		List<TreeNode<T>> otherAncestors = other.getAncestors();
		
		for (TreeNode<T> node1 : myAncestors) {
			for (TreeNode<T> node2 : otherAncestors) {
				if (node1.equals(node2)) return node2;
			}
		}
		/* No common ancestor found */
		return null;
	}
	
	@Override
	public String toString() {
		String s = new String(new char[height+1]).replace("\0", "--- ");
		s = s.concat(element.toString());
		for (TreeNode<T> d : branches) {
			s = s.concat("\n").concat(d.toString());
		}
		return s;
	}
	
}
