package ca.evermann.joerg.blockchainWFMS.main;

public class BlockChainWFMSConfig {

	/*
	 * P2P Constants
	 * 
	 */
	/* Maximum number of connections per P2P node */
	public static final int maxConnections = 2;
	
	/* 
	 * Mining Constants
	 */
	/* Maximum number of transactions per block */
	public static final int maxTransactionsPerBlock = 4;
	/* Difficulty of mining (number of leading zeros in hash) */
	public static final int difficulty = 2;
	/* Maximum time we wait until we begin mining the transaction pool, even if few transactions */
	public static final long maxMiningWaitMillis = 1*60*1000; // 1 minute(s)
	/* Maximum block age */
	public static final long maxBlockAge = 12*60*60*1000; // 12 hours
	public static final long maxBlockNewness = 2*60*60*1000; // 2 hours

	/*
	 * Transaction related
	 */
	/* Minimum number of confirmations */
	public static final int minConfirmDepth = 1;

	/*
	 * Worklist User Interface related
	 */
	/* Width of text input fields in workitem dialog */
	public static final int textFieldWidth = 20;

	static {
		/* TODO */
		/* We may wish to load this from a config file at some point */
		;
	}

}
