package ca.evermann.joerg.blockchainWFMS.main;

import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;

import javax.swing.JTextArea;

public class JTextAreaOutputStream extends OutputStream {

	private JTextArea txtArea;
	private int prevByte = 0;
	
	public JTextAreaOutputStream(JTextArea txtArea) {
		this.txtArea = txtArea;
	}
	
	@Override
	public void write(int b) throws IOException {
        if ( (char)b == '\n' && (char)prevByte != '\n') {
        	txtArea.append(" | " + LocalDateTime.now().toString() + "\n");
        	prevByte = '\n';
        } else {
            txtArea.append(String.valueOf((char)b));
            prevByte = b;
        }
	}

}
