package ca.evermann.joerg.blockchainWFMS.p2p;

import java.io.IOException;
import java.net.*;
import java.util.*;
import ca.evermann.joerg.blockchainWFMS.CA.PeerCertificate;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainWFMSConfig;

public class InboundServer extends NodeServer implements Runnable {

	protected ServerSocket serverSocket;
	
	public InboundServer(P2PNode myNode) throws IOException {
		super(myNode);
		
		serverSocket = new ServerSocket(myNode.myCertificate.getPort());
	}
	
	@Override
	public void run() {
	    Socket clientSocket;
	    while (!stop) {
			try {
				clientSocket = serverSocket.accept();
				InboundConnection iw = new InboundConnection(clientSocket, node.myCertificate, this);
				if (iw.OpenAndVerify()) {
				    synchronized(node.inboundQueues) {
				    	if (!node.activeConnections.containsKey(iw.getOtherCertificate().getHost()+":"+iw.getOtherCertificate().getPort())) {
				    		if (node.activeConnections.size() >= BlockChainWFMSConfig.maxConnections) {
				    			/* 
				    			 * If we have too many active connections, choose one at random and kill it
				    			 */
								Random rndGen = new Random(System.currentTimeMillis());
								int killnum = rndGen.nextInt(node.activeConnections.size());
								PeerConnection conn = (PeerConnection)node.activeConnections.values().toArray()[killnum];
								System.out.println("Stopping connection with " + conn.getOtherCertificate().getHost()+":"+conn.getOtherCertificate().getPort());								
								conn.stop = true;
				    		}
					    	node.inboundQueues.add(iw.getInboundQueue());
					    	node.outboundQueues.put(iw.getOtherCertificate(), iw.getOutboundQueue());
					    	node.activeConnections.put(iw.getOtherCertificate().getHost()+":"+iw.getOtherCertificate().getPort(), iw);
					    	ArrayList<PeerCertificate> newPeers = new ArrayList<PeerCertificate>();
					    	newPeers.add(iw.getOtherCertificate());
					    	node.addPeers(newPeers);
					    	Thread t = new Thread(iw, "Connection worker for " + iw.getOtherCertificate().getHost() + ":" + iw.getOtherCertificate().getPort());
					    	t.start();
							System.out.println("Incoming connection from " + iw.getOtherCertificate().getHost()+":"+iw.getOtherCertificate().getPort());
				    	} else {
				    		iw.shutdown();
				    	}
				    }
				} else { 
					iw.shutdown();
				}
			} catch (IOException e) {
				System.err.println("Socket acceptance failed or socket closed");
				break;
			}
	    }
	    try {
			serverSocket.close();
		} catch (IOException e) {
			System.err.println("Error while closing socket");
		}
	    
	    for (PeerConnection iw : node.activeConnections.values()) {
	    	iw.stop = true;
	    }
	}

}
