package ca.evermann.joerg.blockchainWFMS.p2p;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

import ca.evermann.joerg.blockchainWFMS.CA.PeerCertificate;

public class OutboundConnection extends PeerConnection implements Runnable {

	public OutboundConnection(InetSocketAddress otherAddress, PeerCertificate myCertificate, OutboundServer server) {
		super(myCertificate, server);

		try {
			this.socket = new Socket();
			this.socket.connect(otherAddress, 5000);
			if (!this.socket.isConnected()) {
				System.err.println("Outbound socket connect timeout");
				this.stop = true;
			}
		} catch (IOException e) {
			System.err.println("Cannot open socket to " + otherAddress.toString());
			this.stop = true;
		}
	}
	
	
}
