package ca.evermann.joerg.blockchainWFMS.p2p;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import ca.evermann.joerg.blockchainWFMS.CA.PeerCertificate;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainWFMSConfig;

public class OutboundServer extends NodeServer implements Runnable {

	protected List<String> availableHosts;
	private Set<String> additionalHosts;
	
	public OutboundServer(P2PNode myNode, Set<String> additionalHosts) throws IOException {
		super(myNode);
		
		this.additionalHosts = additionalHosts;
		this.availableHosts = new ArrayList<String>(this.additionalHosts);
		for (PeerCertificate h : myNode.knownPeers) { availableHosts.add(new String(h.getHost()+":"+h.getPort())); }

		Collections.shuffle(this.availableHosts);
	}
	
	@Override
	public void run() {
		while (!stop) {
			if (availableHosts.size() > 0) {

				String host;
				synchronized(availableHosts) {
					host = availableHosts.get(0);
					availableHosts.remove(0);
				}

				String[] hostBits = host.split(":");
				if (hostBits.length != 2) {
					System.err.println("Host is malformed");
					continue;
				}

				InetAddress otherAddr;
				try { 
					otherAddr = InetAddress.getByName(hostBits[0]);
				} catch (UnknownHostException e) {
					System.err.println("Cannot resolve host");
					continue;
				}
				Integer otherPort;
				try {
					otherPort = Integer.parseInt(hostBits[1]);
				} catch (NumberFormatException e) {
					System.err.println("Port is malformed");
					continue;
				}
				
				InetSocketAddress otherSocketAddr = new InetSocketAddress(otherAddr, otherPort);

				if (node.activeConnections.size() < BlockChainWFMSConfig.maxConnections) {
					if (!node.activeConnections.containsKey(hostBits[0]+":"+otherPort)) {
						OutboundConnection cw = new OutboundConnection(otherSocketAddr, node.myCertificate, this);
						if (cw.OpenAndVerify()) {
							synchronized(node.inboundQueues) {
								node.outboundQueues.put(cw.getOtherCertificate(), cw.getOutboundQueue());
								node.inboundQueues.add(cw.getInboundQueue());
								node.activeConnections.put(hostBits[0]+":"+otherPort, cw);
						    	ArrayList<PeerCertificate> newPeers = new ArrayList<PeerCertificate>();
						    	newPeers.add(cw.getOtherCertificate());
								node.addPeers(newPeers);
								Thread t = new Thread(cw, "Connection worker for " + cw.getOtherCertificate().getHost()+":"+cw.getOtherCertificate().getPort());
								t.start();
								System.out.println("Outgoing connection to " + cw.getOtherCertificate().getHost()+":"+cw.getOtherCertificate().getPort());
							}
						} else {
							cw.shutdown();
						}
					}
				} else {
					synchronized(availableHosts) {
						availableHosts.add(host);
					}
				}
			} else {
				synchronized(availableHosts) {
					availableHosts.addAll(this.additionalHosts);
				}
			}
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				System.err.println("Interrupted during sleep");
				continue;
			}
		}
		
	    for (PeerConnection ow : node.activeConnections.values()) {
	    	ow.stop = true;
	    }
	}
}
