package ca.evermann.joerg.blockchainWFMS.p2p.messages;

import java.util.ArrayList;
import java.util.HashSet;

import ca.evermann.joerg.blockchainWFMS.chain.Transaction;

public class TransactionPoolSendMessage extends Message {
	
	public TransactionPoolSendMessage(HashSet<Transaction> txPool) {
		super();

		/* 
		 * We throw this into an ArrayList because the HashSet doesn't seem
		 * to serialize/deserialize identically, so we get different hashes
		 * and cannot verify the content
		 */
		ArrayList<Transaction> tx = new ArrayList<Transaction>();
		tx.addAll(txPool);
		this.payload = txPool;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public String toString() {
		ArrayList<Transaction> t = (ArrayList<Transaction>)payload;
		return new String("TransactionPoolSendMessage with "+String.valueOf(t.size())+" transactions");
	}

}
