package ca.evermann.joerg.blockchainWFMS.workflow;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.Map.Entry;

import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import javax.tools.JavaCompiler.CompilationTask;

import java.util.UUID;
import java.util.Vector;

import ca.evermann.joerg.blockchainWFMS.PetriNet.Transition;
import ca.evermann.joerg.blockchainWFMS.main.BlockChainUtils;

public class ActivityInstance implements Serializable {

	private 			Transition			t;
	private				PetriNetInstance	pni;
	private Map<String, Serializable>		inputValues;
	
	public ActivityInstance(PetriNetInstance pni, Transition t) {
		this.pni = pni;
		this.t = t;
		/* populate the input fields */
		this.inputValues = new TreeMap<String, Serializable>();
		for (String inName : t.getActivity().getInputs()) {
			inputValues.put(inName, BlockChainUtils.deepCopy(pni.getValues().get(inName)));
		}
	}
	
	protected PetriNetInstance getPNI() {
		return pni;
	}
	
	protected void setPNI(PetriNetInstance pni) {
		this.pni = pni;
	}
	
	protected Transition getTransition() {
		return t;
	}
	
	protected String getPNName() {
		return pni.getNet().getName();
	}
	
	protected UUID getCaseId() {
		return pni.getId();
	}
	
	protected Map<String, Serializable> getInputValues() {
		return inputValues;
	}
	
	protected Set<String> getOutputVariables() {
		return t.getActivity().getOutputs();
	}
	
	protected void setOutputValues(Map<String, Serializable> outputs) {
		for (Entry<String, Serializable> e : outputs.entrySet()) {
			this.pni.getValues().put(e.getKey(), BlockChainUtils.deepCopy(e.getValue()));
		}
	}

	@Override
	public int hashCode() {
		return Objects.hash(getCaseId(), getPNName(), t.getName());
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null) return false;
		if (this == obj) return true;
		if (getClass() != obj.getClass()) return false;
		return this.hashCode() == obj.hashCode();
	}
	
	@Override
	public String toString() {
		return new String("Instance of " + t.getName() + " for PN " + getPNName() + " for case " + getCaseId().toString());
	}

	@SuppressWarnings("rawtypes")
	public Map<String, Serializable> callExecute() {
		JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
		DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();

		StringWriter writer = new StringWriter();
		PrintWriter out = new PrintWriter(writer);
		out.println("import java.io.Serializable;");
		for (Class cl : getPNI().getNet().getVariables().values()) {
			out.println("import "+cl.getName()+";");
		}
		out.println("import "+getTransition().getActivity().getExecClass()+";");
		out.println("public class CallExecute {");
		out.print("  public static Serializable exec(");
		Iterator<String> iter = inputValues.keySet().iterator();
		while(iter.hasNext()) {
			String name = iter.next();
			out.print(getPNI().getNet().getVariables().get(name).getName() + " " + name);
			if (iter.hasNext()) {
				out.print(", ");
			}
		}
		out.println(") {");
		out.print("    Serializable r = "+getTransition().getActivity().getExecClass()+"."+getTransition().getActivity().getExecMethod()+"(");
		iter = inputValues.keySet().iterator();
		while(iter.hasNext()) {
			String name = iter.next();
			out.print(name);
			if (iter.hasNext()) {
				out.print(", ");
			}
		}
		out.println(");");
		out.println("    return r;");
		out.println("  }");
		out.println("}");
		out.close();
		JavaFileObject file = new BlockChainUtils.JavaSourceFromString("CallExecute", writer.toString());

		Iterable<? extends JavaFileObject> compilationUnits = Arrays.asList(file);
		CompilationTask task = compiler.getTask(null, null, diagnostics, null, null, compilationUnits);		    
		boolean success = task.call();
		TreeMap<String, Serializable> r = new TreeMap<String, Serializable>();
		if (success) {
			try {
				Vector<Class> inputClasses = new Vector<Class>();
				iter = inputValues.keySet().iterator();
				while(iter.hasNext()) {
					String name = iter.next();
					inputClasses.add(getPNI().getNet().getVariables().get(name));
				}
	            URLClassLoader classLoader = URLClassLoader.newInstance(new URL[] { new File("").toURI().toURL() });
				Serializable obj = (Serializable) Class.forName("CallExecute", true, classLoader).getDeclaredMethod("exec", inputClasses.toArray(new Class[] {})).invoke(null, inputValues.values().toArray() );
				r.put(getTransition().getActivity().getOutputs().toArray(new String[] {})[0], obj);
				return r;
			} catch (ClassNotFoundException e) {
				System.err.println("Class not found: " + e);
			} catch (NoSuchMethodException e) {
				System.err.println("No such method: " + e);
			} catch (IllegalAccessException e) {
				System.err.println("Illegal access: " + e);
			} catch (InvocationTargetException e) {
				System.err.println("Invocation target: " + e);
			} catch (MalformedURLException e) {
				System.err.println("Malformed URL: " + e);
			}
		}
		return r;
	}

}
