package ca.evermann.joerg.blockchainWFMS.workflow;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class Worklist implements Serializable {
	
	private TreeMap<String, TreeMap<String, ActivityInstance>> worklist;
	
	public Worklist() {
		worklist = new TreeMap<String, TreeMap<String, ActivityInstance>>();
	}
	
	public ActivityInstance get(String uuid, String tname) {
		if (!worklist.containsKey(uuid)) {
			return null;
		}
		return worklist.get(uuid).get(tname);
	}
	
	public Set<ActivityInstance> get(String uuid) {
		if (!worklist.containsKey(uuid)) {
			return new HashSet<ActivityInstance>();
		}
		return new HashSet<ActivityInstance>(worklist.get(uuid).values());
	}
	
	public ActivityInstance remove(ActivityInstance ai) {
		if (!worklist.containsKey(ai.getCaseId().toString())) {
			return null;
		}
		return worklist.get(ai.getCaseId().toString()).remove(ai.getTransition().getName());
	}
	
	public ActivityInstance remove(String caseId, String tName) {
		if (!worklist.containsKey(caseId)) {
			return null;
		}
		return worklist.get(caseId).remove(tName);
	}
	
	public void removeCase(String uuid) {
		worklist.remove(uuid);
	}

	public ActivityInstance put(ActivityInstance ai) {
		if (!worklist.containsKey(ai.getCaseId().toString())) {
			worklist.put(ai.getCaseId().toString(), new TreeMap<String, ActivityInstance>());
		}
		return worklist.get(ai.getCaseId().toString()).put(ai.getTransition().getName(), ai);
	}
	
	public List<ActivityInstance> asList() {
		List<ActivityInstance> r = new Vector<ActivityInstance>();
		for (TreeMap<String, ActivityInstance> m : worklist.values()) {
			r.addAll(m.values());
		}
		return r;
	}
	
	@Override
	public String toString() {
		String s = new String("  Worklisted Items:\n");
		for (ActivityInstance a : asList()) {
			s = s.concat("    " + a.toString() + "\n");
		}
		return s;
	}
}
