/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.clientsmanagement;

import bftsmart.clientsmanagement.RequestList;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientData {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    ReentrantLock clientLock = new ReentrantLock();
    private int clientId;
    private int session = -1;
    private int lastMessageReceived = -1;
    private long lastMessageReceivedTime = 0L;
    private int lastMessageDelivered = -1;
    private RequestList pendingRequests = new RequestList();
    private RequestList orderedRequests = new RequestList(5);
    private Signature signatureVerificator = null;

    public ClientData(int clientId, PublicKey publicKey) {
        this.clientId = clientId;
        if (publicKey != null) {
            try {
                this.signatureVerificator = TOMUtil.getSigEngine();
                this.signatureVerificator.initVerify(publicKey);
                this.logger.debug("Signature verifier initialized for client " + clientId);
            }
            catch (Exception ex) {
                this.logger.error("Failed to create client data object", (Throwable)ex);
            }
        }
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public RequestList getPendingRequests() {
        return this.pendingRequests;
    }

    public RequestList getOrderedRequests() {
        return this.orderedRequests;
    }

    public void setLastMessageDelivered(int lastMessageDelivered) {
        this.lastMessageDelivered = lastMessageDelivered;
    }

    public int getLastMessageDelivered() {
        return this.lastMessageDelivered;
    }

    public void setLastMessageReceived(int lastMessageReceived) {
        this.lastMessageReceived = lastMessageReceived;
    }

    public int getLastMessageReceived() {
        return this.lastMessageReceived;
    }

    public void setLastMessageReceivedTime(long lastMessageReceivedTime) {
        this.lastMessageReceivedTime = lastMessageReceivedTime;
    }

    public long getLastMessageReceivedTime() {
        return this.lastMessageReceivedTime;
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        if (this.signatureVerificator != null) {
            try {
                return TOMUtil.verifySignature(this.signatureVerificator, message, signature);
            }
            catch (SignatureException ex) {
                this.logger.error("Failed to verify signature", (Throwable)ex);
            }
        }
        return false;
    }

    public boolean removeOrderedRequest(TOMMessage request) {
        if (this.pendingRequests.remove(request)) {
            this.orderedRequests.addLast(request);
            return true;
        }
        return false;
    }

    public boolean removeRequest(TOMMessage request) {
        this.lastMessageDelivered = request.getSequence();
        boolean result = this.pendingRequests.remove(request);
        this.orderedRequests.addLast(request);
        Iterator it = this.pendingRequests.iterator();
        while (it.hasNext()) {
            TOMMessage msg = (TOMMessage)it.next();
            if (msg.getSequence() >= request.getSequence()) continue;
            it.remove();
        }
        return result;
    }

    public TOMMessage getReply(int reqSequence) {
        TOMMessage request = this.orderedRequests.getBySequence(reqSequence);
        if (request != null) {
            return request.reply;
        }
        return null;
    }
}

